import java.util.*;
import java.text.*;
import java.io.*;
/*
*contains xyz coords and inf from atom, performs translation of xyz coords
*/
public class xyzCoords implements Serializable
{
	public float X, Y, Z;
      	public String Atominf, Xstr, Ystr, Zstr;
		
	public xyzCoords( String atominf, String xstr, String ystr, String zstr ) 
	{
		Atominf = atominf;
		
		Xstr = xstr;
		Ystr = ystr;
		Zstr = zstr;
		
		X = (new Float( xstr )).floatValue();
		Y = (new Float( ystr )).floatValue();
		Z = (new Float( zstr )).floatValue();
      	}
	
	public void translate( float x, float y, float z )
	{
		X = X - x;
		Y = Y - y;
		Z = Z - z;
		
		//round to 3 dec. pl.
		DecimalFormat sciformat = new DecimalFormat("0.000");                                                                
		Xstr = sciformat.format( X );
		Ystr = sciformat.format( Y );
		Zstr = sciformat.format( Z );	
	}
	
	public float getX()
	{
		return X;
	}
	
	public float getY()
	{
		return Y;
	}
	
	public float getZ()
	{
		return Z;
	}
	
	public String getAtominf()
	{
		return Atominf;
	}
	
	public String getXstr()
	{
		return Xstr;
	}
	
	public String getYstr()
	{
		return Ystr;
	}
	
	public String getZstr()
	{
		return Zstr;
	}
	
	public String getFormattedXYZstr()
	{
		//get decimal points in correct place for CA coords
		String space = "";
		StringTokenizer xtoks = new StringTokenizer( Xstr, "." );
		String xtoksstr = xtoks.nextToken();
		for( int l = 0; l < 8-xtoksstr.length(); l++ )
			space = space + " ";
		Xstr = space  + Xstr;

		space = "";
		StringTokenizer ytoks = new StringTokenizer( Ystr, "." );
		String ytoksstr = ytoks.nextToken();
		for( int l = 0; l < 4-ytoksstr.length(); l++ )
			space = space + " ";
		Ystr = space  + Ystr;

		space = "";
		StringTokenizer ztoks = new StringTokenizer( Zstr, "." );
		String ztoksstr = ztoks.nextToken();
		for( int l = 0; l < 4-ztoksstr.length(); l++ )
			space = space + " ";
		Zstr = space  + Zstr;
		
		return Xstr + Ystr + Zstr;
	}
	
	public String toString()
	{
		return getFormattedXYZstr();
	}
	
	public static void main( String args[] )
	{
		xyzCoords xyz = new xyzCoords( args[0], args[1], args[2], args[3] );
		xyz.translate( -1, -1, -1 );
		System.out.println( xyz.getAtominf() + " " + xyz.getXstr() + " " + xyz.getYstr() + " " + xyz.getZstr() );
		System.out.println( xyz.getAtominf() + xyz.getFormattedXYZstr() );
	}	
	
}