import java.util.*;
import java.io.*;

/**
*run_i3Drefine - wrapper for i3Drefine
*/
public class run_i3Drefine_bfact_thread extends Thread
{	
	Runtime r = Runtime.getRuntime();
	Process p = null;
	String modelname, outputdirectory, refined_direct;
	int iterations;
	
	public run_i3Drefine_bfact_thread( String Modelname, int Iterations,  String Outputdirectory, String Refined_direct )
	{
		modelname = Modelname;
		outputdirectory = Outputdirectory;
		refined_direct = Refined_direct;
		iterations = Iterations;
	}
	
	public void run()
	{
		try
		{
			String[] runi3Drefine = {"/bin/bash", "-c", "cd "+outputdirectory+" ;$i3Drefine/i3Drefine/bin/i3Drefine.sh " + modelname + " "  + iterations };
			System.out.println( "$i3Drefine/i3Drefine/bin/i3Drefine.sh " + modelname + " "  + iterations );
			p = r.exec( runi3Drefine );
			BufferedReader in = new BufferedReader( new InputStreamReader( p.getInputStream() ) );
			String line = in.readLine();
			String refinedModsDirectStr = "";
			while( line != null )
			{
				if( line.startsWith( "Job ID = " ) )
				{
					refinedModsDirectStr = line.substring( line.indexOf("=")+1 ).trim();
				}
				
				if( line.startsWith("Can't" ) )
				{
					System.out.println( line );
				}
				line = in.readLine();
			}
			p.waitFor();
			in.close();
			p.destroy();
			
			File refinedModsDirect = new File( outputdirectory + refinedModsDirectStr + "/RESULT/");
			
			if( !refinedModsDirectStr.equals("") && refinedModsDirect.exists() )
			{
				//mv files and rename
				String directory[] = refinedModsDirect.list();
				for( int i = 0; i < directory.length; i++ )
				{
					File refinedMod = new File( outputdirectory + refinedModsDirectStr + "/RESULT/" + directory[i] );
					refinedMod.renameTo(new File( refined_direct + modelname + "_" + directory[i] ) );
					System.out.println( "Moved model " + i + " to : " + outputdirectory + modelname + "_" + directory[i] );
				}
			}
			else
			{
				System.out.println( "Cannot find refined models directory!" + outputdirectory + refinedModsDirectStr + "/RESULT/" );
			}
		}
		catch( Exception e )
		{
		      System.out.println( "Error running run_i3Drefine!\n" + e );
		}
	}
	
	
	public static void main( String args[])
	{
		run_i3Drefine_bfact_thread runi3Dref = new run_i3Drefine_bfact_thread( args[0], (new Integer( args[1] )).intValue(), args[2], args[3] );
		runi3Dref.start();
	}	
}