import java.io.*;
import java.util.*;
/**
*A simple wrapper for TM-SCORE by Yang Zhang and Jeffrey Skolnick, Proteins 2004 57: 702-710
*This version parses the residue information from the aligned structures.
*/
public class runTMscoreResEuc_mod
{
	Runtime r = Runtime.getRuntime();
	Process p = null;

	float TMscore = 0, MaxSubscore = 0, GDTscore = 0;
	int numSuperposedRes = 0;
	Vector pdbvect1 = new Vector();
	Vector pdbvect2 = new Vector();
	Vector distvect1 = new Vector();
	Vector distvect2 = new Vector();
	
	public runTMscoreResEuc_mod( String pdbfile1, String pdbfile2, String direct, float d, boolean keepoutputfile )
	{
		try
		{
			TMscore_mod tmsmod = new TMscore_mod( pdbfile1, pdbfile2, direct, (new Float(d)).toString() );
			TMscore = (new Double(tmsmod.getTMscore())).floatValue();
			MaxSubscore = (new Double(tmsmod.getMaxSubscore())).floatValue();
			GDTscore = (new Double(tmsmod.getGDTscore())).floatValue();
			String pdbstr1 = tmsmod.getSequenceA();
			String alnresstr = tmsmod.getSequenceM();
			String pdbstr2 = tmsmod.getSequenceB();
			boolean enough_common_residues = tmsmod.enoughAlignedResidues();
			String supString = tmsmod.getSupString();

			//System.out.println( TMscore );

			char c1 = ' ';
			char caln = ' ';
			char c2 = ' ';
	    
			if( enough_common_residues )
			{
				for( int i = 0; i < pdbstr1.length(); i++ )
				{
					c1 = pdbstr1.charAt(i);
					caln = alnresstr.charAt(i);
					c2 = pdbstr2.charAt(i);
					
					//THIS VERSION CONSIDERS ALL PAIRS OF RESIDUES
					if( c1 != '-' && c2 != '-' )
					{
						pdbvect1.addElement( new Integer( 1 ) );
						pdbvect2.addElement( new Integer( 1 ) );
					}
					
					if( c1 == '-' )
						pdbvect2.addElement( new Integer( 0 ) );	
					
					if( c2 == '-' )
						pdbvect1.addElement( new Integer( 0 ) );
					
					//THIS VERSION ONLY CONSIDERS PAIRS OF RESIDUES THAT ARE ALIGNED WITHIN THE CUT-OFF
// 					if(c1 != '-' )
// 					{
// 						if( caln == ':')
// 						{
// 							pdbvect1.addElement( new Integer( 1 ) );
// 							numSuperposedRes++;
// 						}
// 						else
// 							pdbvect1.addElement( new Integer( 0 ) );
// 					}
// 					if(c2 != '-' )
// 					{ 
// 						if( caln == ':')
// 						{
// 							pdbvect2.addElement( new Integer( 1 ) );
// 						}
// 						else
// 							pdbvect2.addElement( new Integer( 0 ) );	
// 					}
				}
				//System.out.println(pdbstr1+"\n"+alnresstr+"\n"+pdbstr2);
				
				//calc Euclidean distance between equivalent residues
				//read superposition file
				//make vector of cartesian coords < Angstrom cutoff defined
				Vector coordsVect = new Vector();
				
				//faster to read from supString stored in RAM instead of I/O from saved file
				StringTokenizer suptoks = new StringTokenizer( supString, "\n" );
				String line = suptoks.nextToken();
				int v = 0;
				//read coords of first model
				do
				{
					if( line.startsWith("ATOM") )
					{
						int match = ((Integer)pdbvect1.elementAt(v)).intValue();
						if( match == 1 )
						{
							String atominf = line.substring( 0, 26 );
							String xstr = line.substring(30,38).trim();
							String ystr = line.substring(38,46).trim();
							String zstr = line.substring(47,54).trim();
							xyzCoords xyz = new xyzCoords( atominf, xstr, ystr, zstr );
							coordsVect.addElement( xyz );
							//System.out.println( line );
						} 
						v++;
					}
					line = suptoks.nextToken();
				}
				while( suptoks.hasMoreTokens() && !line.startsWith("TER") );
				
				v = 0;
				int v1 = 0;
				Vector distvect = new Vector();
				//read coords of second model
				do
				{
					if( line.startsWith("ATOM") )
					{
						int match = ((Integer)pdbvect2.elementAt(v)).intValue();
						if( match == 1 )
						{
							String atominf = line.substring( 0, 26 );
							String xstr = line.substring(30,38).trim();
							String ystr = line.substring(38,46).trim();
							String zstr = line.substring(47,54).trim();
							xyzCoords xyz2 = new xyzCoords( atominf, xstr, ystr, zstr );
							xyzCoords xyz1 = (xyzCoords)coordsVect.elementAt( v1 );
							//System.out.println( xyz1 + "\n" + xyz2 );
							float x1 = xyz1.getX();
							float y1 = xyz1.getY();
							float z1 = xyz1.getZ();
							float x2 = xyz2.getX();
							float y2 = xyz2.getY();
							float z2 = xyz2.getZ();
							
							double distance = Math.sqrt( ((x1-x2)*(x1-x2)) + ((y1-y2)*(y1-y2)) + ((z1-z2)*(z1-z2)) );

							//si score
							distance = 1/(1+((distance/d)*(distance/d)));
							
							distvect.addElement( new Double(distance) );
							v1++;
						} 
						v++;
					}
					line = suptoks.nextToken();
				}
				while( suptoks.hasMoreTokens() && !line.startsWith("TER") );
				
				//System.out.println( distvect );
				
				//Vector distvect1 = new Vector();
				int a2 = 0;
				for( int a = 0; a < pdbvect1.size(); a++)
				{
					int match = ((Integer)pdbvect1.elementAt(a)).intValue();
					int num = a+1;
					if( match == 1 )
					{
						//System.out.println( num + " " + (Double)distvect.elementAt(a2) );
						distvect1.addElement( (Double)distvect.elementAt(a2) ); 
						a2++;
						
					}
					else
					{
						//System.out.println( num + " 0.0 ");
						distvect1.addElement( new Double( 0.0 ) );
					}
				}
				//System.out.println( distvect1 );
				
				//Vector distvect2 = new Vector();
				a2 = 0;
				for( int a = 0; a < pdbvect2.size(); a++)
				{
					int match = ((Integer)pdbvect2.elementAt(a)).intValue();
					
					if( match == 1 )
					{
						distvect2.addElement( (Double)distvect.elementAt(a2) ); 
						a2++;
					}
					else
						distvect2.addElement( new Double( 0.0 ) );
					
				}
				//System.out.println( distvect2 );
			}
			
			//write to file if it is to be saved
			if( keepoutputfile )
			{
				DataOutputStream out = new DataOutputStream( new FileOutputStream( direct + pdbfile1 + "_" + pdbfile2 +".TM" ) );
				out.writeBytes( supString );
				out.close();
			}
		}

		catch( Exception e )
		{
			System.out.println( "Error executing TMscore!" + e );
		}
	}


	public float getTMscore()
	{
		return TMscore;
	}

	public float getMaxSubscore()
	{
		return MaxSubscore;
	}

	public float getGDTscore()
	{
		return GDTscore;
	}
	
	public Vector getpdbvect1()
	{
		return pdbvect1;
	}
	
	public Vector getpdbvect2()
	{
		return pdbvect2;
	}
	
	public Vector getdistvect1()
	{
		return distvect1;
	}
	
	public Vector getdistvect2()
	{
		return distvect2;
	}
	
	public int getnumSuperposedRes()
	{
		return numSuperposedRes;
	}

	public static void main( String args[])
	{
		float d = ( new Float( args[3] ) ).floatValue();
		boolean keepoutputfile = true;
		if(  args[4].equals( "false" ) )
			keepoutputfile = false;
		runTMscoreResEuc_mod rtmre2 = new runTMscoreResEuc_mod( args[0], args[1], args[2], d, keepoutputfile );
		//System.out.println( args[0] + " " + rtmre.getTMscore() + " " + rtmre.getMaxSubscore() + " " + rtmre.getGDTscore() + "\n" + rtmre.getpdbvect1() + " " + rtmre.getpdbvect1().size() + "\n" + rtmre.getdistvect1() + " " + rtmre.getdistvect1().size() );
		System.out.println( args[0] + " " + rtmre2.getTMscore() + " " + rtmre2.getMaxSubscore() + " " + rtmre2.getGDTscore() + "\n" + rtmre2.getdistvect1() + " " + rtmre2.getdistvect1().size() + "\n" + rtmre2.getdistvect2() + " " + rtmre2.getdistvect2().size() );
	}
}
