import java.util.*;
import java.text.*;
import java.io.*;

/**
*Single model mode clustering
*/
public class run3DJuryRes2v1_1_single_bfact_mod
{

        Runtime r = Runtime.getRuntime();
        Process p = null;

        public run3DJuryRes2v1_1_single_bfact_mod( String inputdirectory, String uploadedmodelsdirectory, String target, String sequence, String bfact_outputdirectory )
        {	
		try
		{
			//mkdir tmp directory here
			p = r.exec( "mkdir " + inputdirectory + "/tmp_mod.out/");
			p.waitFor();
			p.destroy();
										
			DataOutputStream out = new DataOutputStream( new FileOutputStream( inputdirectory + "/" + target +"_ModFOLDclust_single.unsort" ) );
			TreeMap resnumMap = new TreeMap();
			TreeMap resscoreMap = new TreeMap();
			//read input directory and find pdb files
			File direct = new File( uploadedmodelsdirectory );
			String directory[] = direct.list();
			for( int i = 0; i < directory.length; i++ )
			{
				String actualfilename = directory[i];
				
				String actualfilenamesub = actualfilename;
					
				System.out.println( actualfilename );
			
				float juryscore = 0.0F;
				float juryresscore = 0.0F;
				float totjuryresscore = 0.0F;
				float totalscore = 0.0F;
				float d = 3.9F; //distance cut off for TMscore
				int n = 0;
				Vector totalvect = new Vector();
				Vector totalpdbvect = new Vector();
				
				//read input directory and find pdb files
				File direct2 = new File( inputdirectory );
				String directory2[] = direct2.list();
				for( int j = 0; j < directory2.length; j++ )
				{
					String actualfilename2 = directory2[j];
					
					String actualfilenamesub2 = actualfilename2;
					
					//if refined model check that it is not comparing pre-refined version of model
					boolean pre_refined = false;
					if( actualfilename.contains( actualfilename2 ) && actualfilename.contains("REFINED" ) )
					{	
						pre_refined = true;
						System.out.println( actualfilename2 + " is pre-refined version of " + actualfilename  );
					}
					
					if( !pre_refined && !actualfilename2.endsWith( "_ModFOLDclust_single.unsort" ) && !actualfilename2.equals( "tmp.out" ) && !actualfilename2.equals( "tmp_mod.out" ) && !actualfilename.equals( actualfilename2 ) )
					{
						System.out.println( actualfilename + " " + actualfilename2 );

						//copy models to tmp direct for comparison
						p = r.exec( "cp " + uploadedmodelsdirectory + actualfilename + " " + inputdirectory + "/tmp_mod.out/");
						p.waitFor();
						p.destroy();
						p = r.exec( "cp " + inputdirectory + actualfilename2 + " " + inputdirectory + "/tmp_mod.out/");
						p.waitFor();
						p.destroy();

						runTMscoreResEuc_mod rtmr = new runTMscoreResEuc_mod( actualfilename, actualfilename2, inputdirectory+ "/tmp_mod.out/", d,  false );
						
						float tm = rtmr.getTMscore();
						if( tm < 1.0 )//do not include scores == 1.0 as these are the identical models and will skew the scores/rankings slightly.
						{
							if(tm>=0.2)
							{
								totalscore = totalscore + tm;
							}
							
							Vector vect1 = rtmr.getdistvect1();
							//System.out.println(vect1);
							if( vect1.size() > 0 )
							{
								for( int v = 0; v < vect1.size(); v++ )
								{
									//System.out.println(totalvect);
									//N.B. this is the si score
									double resscore = ((Double)vect1.elementAt(v)).doubleValue();
									//System.out.println(resscore);
							
									if( n > 0 && totalvect.size() ==  vect1.size() )
									//if( n > 0 && totalvect.size() > 0 )
									{
										double resscore2 = ((Double)totalvect.elementAt(v)).doubleValue();
										double totres = resscore+resscore2;
										//System.out.println(totres);
										totalvect.setElementAt( new Double(totres), v );
									}
									else if( n == 0 || totalvect.size() < vect1.size() )
									//else if( n == 0 || totalvect.size() == 0 )
									{
										totalvect.addElement( new Double( resscore ) );
									}
								}
							}
							//System.out.println(totalvect);
							
							Vector pdbvect = rtmr.getpdbvect1();
							if( pdbvect.size() > 0 )
							{
								for( int v = 0; v < pdbvect.size(); v++ )
								{
									int resscore = ((Integer)pdbvect.elementAt(v)).intValue();
									
									if( n > 0 && totalpdbvect.size() == pdbvect.size() )
									//if( n > 0 && totalpdbvect.size() > 0 )
									{
										int resscore2 = ((Integer)totalpdbvect.elementAt(v)).intValue();
										int totres = resscore+resscore2;
										//System.out.println(totres);
										totalpdbvect.setElementAt( new Integer(totres), v );
									}
									else if( n == 0 || totalpdbvect.size() <  pdbvect.size() )
									//else if( n == 0 || totalpdbvect.size() == 0 )
									{
										totalpdbvect.addElement( new Integer( resscore ) );
									}
								}
							}
							//System.out.println(pdbvect);
							//System.out.println(totalvect);
							
							n++;
						}
					}
				}
				
				//get residue numbering from model file and put into order using TreeMap
				BufferedReader in = new BufferedReader( new FileReader( uploadedmodelsdirectory + "/" + actualfilename ) );
				String line = in.readLine();
				TreeMap resMap = new TreeMap();
				DecimalFormat sciformat1 = new DecimalFormat("0.00");
				DecimalFormat sciformat2 = new DecimalFormat("0.00000");
				StringBuffer meanresscorebuf = new StringBuffer();
				int v = 0;
				int resnumint = 0;
				int currentresnumint = 0;
				String resscorestr = "";
				
				//check PDB file is not just all CA ATOMS
				//System.out.println( "Checking PDB file..." );
				String[] grep = {"/bin/bash", "-c", "grep \"ATOM\"  " + uploadedmodelsdirectory + "/" + actualfilename + " | grep \" CA \" | wc -l" };
				p = r.exec(grep);
				BufferedReader pin = new BufferedReader( new InputStreamReader( p.getInputStream() ) );
				int numberCA = (new Integer(pin.readLine())).intValue();
				p.waitFor();
				p.destroy();
				pin.close();
				//System.out.println( "grep \"ATOM\"  " + inputdirectory + "/" + actualfilename + " | grep \" CA \" | wc -l" );
				
				String[] grep2 = {"/bin/bash", "-c", "grep \"ATOM\"  " + uploadedmodelsdirectory + "/" + actualfilename + " | wc -l" };
				p = r.exec(grep2);
				pin = new BufferedReader( new InputStreamReader( p.getInputStream() ) );
				int numberlines = (new Integer(pin.readLine())).intValue();
				p.waitFor();
				p.destroy();
				pin.close();
				//System.out.println( "grep \"ATOM\"  " + inputdirectory + "/" + actualfilename + " | wc -l" );

				if( numberlines == numberCA )
				{
					System.out.println( "Running BBQ on model as it seems to have only CA coords." );
					runBBQ rbbq = new runBBQ( actualfilename, uploadedmodelsdirectory );
					System.out.println( "Finished running BBQ!" );
				}
				
				BufferedReader in2 = new BufferedReader( new FileReader( uploadedmodelsdirectory + "/" + actualfilename ) );
				line = in2.readLine();
				
				if( line != null )
				{
					DataOutputStream out2 = new DataOutputStream( new FileOutputStream( bfact_outputdirectory + "/" + actualfilename +".bfact" ) );
					System.out.println( "\"B-factor\" file: " + inputdirectory + "/" + actualfilename +".bfact" );
					do
					{
						//System.out.println( line );
						if( line.startsWith("ATOM") && line.length() >= 60 )
						{
							String resnumstr = line.substring(22, 26).trim();
							Integer resnum = new Integer( resnumstr );
							resnumint = resnum.intValue();

							if( v < totalvect.size() )
							{
								if(  resnumint >  currentresnumint  )
								{
									//System.out.println(line);
									float totresdist = ((Double)totalvect.elementAt(v)).floatValue();
									//int totresnum  = ((Integer)totalpdbvect.elementAt(v)).intValue();
									//juryresscore = totresdist/totresnum;
									juryresscore = totresdist/n;
									
									//report value of di i.e. work out distance in Angstroms from si value
									//si=1/(1+((di/d0)^2))
									//therefore di=d0*(SQRT((1/si)-1))
									juryresscore = (new Double((Math.sqrt((1/juryresscore)-1))) ).floatValue();
									juryresscore = d*juryresscore;
									
									if( juryresscore > 15 )
									{
										juryresscore = 15.0F;
									}

									resMap.put( resnum, sciformat2.format(juryresscore) );
									//System.out.println(resMap + "\n" + sciformat.format( juryresscore ));
									v++;
									
									//format string and get spacing correct
									resscorestr = sciformat1.format(juryresscore);
									resscorestr = " " + resscorestr;
									if( resscorestr.length() == 5 )
										resscorestr = " " + resscorestr;
										
									out2.writeBytes( line.substring(0,60) + resscorestr + "\n" );
								}
							}
							
							if(  resnumint == currentresnumint )
							{
								out2.writeBytes( line.substring(0,60) + resscorestr + "\n" );
							}
							currentresnumint = resnumint;
						}
						
			
						line = in2.readLine();
						
						if( line == null )
							line = "TER";
					}
					while( !line.startsWith( "TER" ) && !line.startsWith( "END" ) );
					in2.close();
					out2.writeBytes( "TER\nEND\n" );
					out2.close();
					
					//create images to go with residue scoring - rasmol with colouring
					//System.out.println( "cd "+ bfact_outputdirectory + ";/home/Liam/programs/bin/rasmol_32BIT -nodisplay " + actualfilename +".bfact < /home/Liam/programs/bin/rasmol.script" );
					String[] rasmol = {"/bin/bash", "-c", "cd "+ bfact_outputdirectory + ";$RASMOL/rasmol_32BIT -nodisplay " + actualfilename +".bfact < $RASMOL/rasmol.script" };
					p = r.exec( rasmol );
					pin = new BufferedReader( new InputStreamReader( p.getInputStream() ) );
					String rasmolline = pin.readLine();
					do
					{
						//System.out.println( line );
						rasmolline = pin.readLine();
	
					}
					while( rasmolline != null );
					p.waitFor();
					pin.close();
					p.destroy();
					
					//System.out.println( "cd "+ bfact_outputdirectory + ";/usr/bin/ppmtojpeg test.ppm > " + actualfilename + ".bfact.jpeg" );
					String[] jpeg = {"/bin/bash", "-c", "cd "+ bfact_outputdirectory + ";/usr/bin/ppmtojpeg test.ppm > " + actualfilename + ".bfact.jpeg" };
					//String[] jpeg = {"/bin/bash", "-c", "cd "+ bfact_outputdirectory + ";mv test.gif > " + actualfilename + ".bfact.gif" };
					p = r.exec( jpeg );
					p.waitFor();
					p.destroy();
					
					//System.out.println( "cd "+ bfact_outputdirectory + ";/usr/bin/mogrify -trim " + actualfilename + ".bfact.jpeg" );
					String[] mogrify = {"/bin/bash", "-c", "cd "+ bfact_outputdirectory + ";/usr/bin/mogrify -trim " + actualfilename + ".bfact.jpeg" };
					p = r.exec( mogrify );
					p.waitFor();
					p.destroy();

					String[] mv = {"/bin/bash", "-c", "cd "+ bfact_outputdirectory + ";/bin/cp "+ actualfilename + ".bfact.jpeg " + actualfilename + ".bfact.thumb.jpeg" };
					p = r.exec( mv );
					p.waitFor();
					p.destroy();

					String[] mogrify6 = {"/bin/bash", "-c", "cd "+ bfact_outputdirectory + ";/usr/bin/mogrify -resize 25% " + actualfilename + ".bfact.thumb.jpeg" };
					p = r.exec( mogrify6 );
					p.waitFor();
					p.destroy();

					//System.out.println( totalvect + "\n" + resMap );
					
					//output scores for plots and QMODE 2 file
					DataOutputStream out3 = new DataOutputStream( new FileOutputStream( bfact_outputdirectory + "/" + actualfilename +".gnuplot" ) );
					//System.out.println(sequence.length());
					for( int aa = 1; aa < sequence.length()+1; aa++ )
					{
						String resscorestr2 = "";
						if( resMap.containsKey( new Integer( aa ) ) )
						{
							resscorestr2 = (String)resMap.get( new Integer( aa ) );
						}
						else
							resscorestr2 = "X";
							
						//System.out.println( aa + " " + resscorestr2 );
						
						meanresscorebuf.append( " " + resscorestr2 );
						
						//this is so we can add missing residues on the plot
						if( !resscorestr2.equals( "X" ) )
							out3.writeBytes( aa + " " + resscorestr2 + " NaN\n" );
						
						else if( resscorestr2.equals( "X" ) )
							out3.writeBytes( aa + " 0.0 7.5\n" );
					}
					out3.close();
					
					//create plot to go with residue scoring - use data above with gnuplot
					//System.out.println( "cd "+ bfact_outputdirectory + ";/usr/bin/gnuplot < /home/Liam/programs/bin/gnuplot.script" );
					String[] gnuplot = {"/bin/bash", "-c", "cd "+ bfact_outputdirectory + ";cp " + actualfilename +".gnuplot test.gnuplot;/usr/bin/gnuplot < /home/Liam/programs/bin/gnuplot.script" };
					p = r.exec( gnuplot );
					pin = new BufferedReader( new InputStreamReader( p.getInputStream() ) );
					String gnuplotline = pin.readLine();
					do
					{
						//System.out.println( line );
						gnuplotline = pin.readLine();
	
					}
					while( gnuplotline != null );
					p.waitFor();
					pin.close();
					p.destroy();
					
					String[] mv2 = {"/bin/bash", "-c", "cd "+ bfact_outputdirectory + ";/bin/mv test.ps " + actualfilename + ".gnuplot.ps" };
					p = r.exec( mv2 );
					p.waitFor();
					p.destroy();
					
					//System.out.println( "cd "+ bfact_outputdirectory + ";/usr/bin/gs -sDEVICE=jpeg -dJPEGQ=100 -dNOPAUSE -dBATCH -dSAFER -r300 -sOutputFile=" + actualfilename + ".gnuplot.jpeg test.ps" );
					String[] jpeg2 = {"/bin/bash", "-c", "cd "+ bfact_outputdirectory + ";/usr/bin/gs -sDEVICE=jpeg -dJPEGQ=100 -dNOPAUSE -dBATCH -dSAFER -r300 -sOutputFile=" + actualfilename + ".gnuplot.jpeg " + actualfilename + ".gnuplot.ps " };
					p = r.exec( jpeg2 );
					pin = new BufferedReader( new InputStreamReader( p.getInputStream() ) );
					String gsline = pin.readLine();
					do
					{
						//System.out.println( line );
						gsline = pin.readLine();
	
					}
					while( gsline != null );
					p.waitFor();
					pin.close();
					p.destroy();
					
					//System.out.println( "cd "+ bfact_outputdirectory + ";/usr/bin/mogrify -rotate 90 " + actualfilename + ".gnuplot.jpeg" );
					String[] mogrify2 = {"/bin/bash", "-c", "cd "+ bfact_outputdirectory + ";/usr/bin/mogrify -rotate 90 " + actualfilename + ".gnuplot.jpeg" };
					p = r.exec( mogrify2 );
					p.waitFor();
					p.destroy();
					
					//System.out.println( "cd "+ bfact_outputdirectory + ";/usr/bin/mogrify -resize 800x600 " + actualfilename + ".gnuplot.jpeg" );
					String[] mogrify3 = {"/bin/bash", "-c", "cd "+ bfact_outputdirectory + ";/usr/bin/mogrify -resize 800x600 " + actualfilename + ".gnuplot.jpeg" };
					p = r.exec( mogrify3 );
					p.waitFor();
					p.destroy();
					
					//System.out.println( "cd "+ bfact_outputdirectory + ";/usr/bin/mogrify -trim " + actualfilename + ".gnuplot.jpeg" );
					String[] mogrify4 = {"/bin/bash", "-c", "cd "+ bfact_outputdirectory + ";/usr/bin/mogrify -trim " + actualfilename + ".gnuplot.jpeg" };
					p = r.exec( mogrify4 );
					p.waitFor();
					p.destroy();

					String[] mv3 = {"/bin/bash", "-c", "cd "+ bfact_outputdirectory + ";/bin/cp "+ actualfilename + ".gnuplot.jpeg " + actualfilename + ".gnuplot.thumb.jpeg" };
					p = r.exec( mv3 );
					p.waitFor();
					p.destroy();

					String[] mogrify5 = {"/bin/bash", "-c", "cd "+ bfact_outputdirectory + ";/usr/bin/mogrify -resize 25% " + actualfilename + ".gnuplot.thumb.jpeg" };
					p = r.exec( mogrify5 );
					p.waitFor();
					p.destroy();

// 					for( int aa = 1; aa < sequence.length()+1; aa++ )
// 					{
// 						String resscorestr2 = "";
// 						if( resMap.containsKey( new Integer( aa ) ) )
// 						{
// 							resscorestr2 = (String)resMap.get( new Integer( aa ) );
// 						}
// 						else
// 							resscorestr2 = "X";
// 							
// 						//System.out.println( aa + " " + resscorestr2 );
// 						meanresscorebuf.append( " " + resscorestr2 );
// 						
// 					}
				}

				//totjuryresscore = totjuryresscore/totalvect.size();
				totjuryresscore = totjuryresscore/sequence.length();
				
				//juryscore = totalscore/(n+1);
				juryscore = totalscore/(n); //(n+1) not needed here

				if( meanresscorebuf.toString().length() > 0 )
					out.writeBytes( actualfilename + " " + sciformat2.format(juryscore) + meanresscorebuf.toString() + "\n" );

				//handle cases where there are no coords for model
				else if( meanresscorebuf.toString().length() == 0 )
				{
					StringBuffer nomodelbuf = new StringBuffer();
					for( int x = 0; x < sequence.length(); x++ )
					{
						nomodelbuf.append( " X" );
					}
					out.writeBytes( actualfilename + " X" + nomodelbuf.toString() +"\n");
				}
			}
			out.close();

			//rm tmp directory here
			p = r.exec( "rm -rf " + inputdirectory + "/tmp_mod.out/");
			p.waitFor();
			p.destroy();
		}

		catch( Exception e )
		{
			System.out.println( "Error executing run3DJuryRes2v1_1_single_bfact!\n" + e );
		}
	}
	public static void main( String args[])
	{
                if( args.length == 0 )
                    System.out.println( "usage: java run3DJuryRes2v1_1_single_bfact <input directory> <uploadedmodelsdirectory> <target name> <target sequence file>");

                if( args.length != 0 )
                {
			try
			{
				BufferedReader in = new BufferedReader( new FileReader( args[3] ) );
				in.readLine();
				String line = in.readLine();
				String seq = "";
				do
				{
					seq = seq + line;
					line = in.readLine();
				}
				while( line != null );
				in.close();
				seq = seq.replaceAll( " ", "" );
				//System.out.println( seq );
                        	new run3DJuryRes2v1_1_single_bfact_mod( args[0], args[1], args[2], seq, args[4]);
			}
			catch( IOException e )
			{
				System.out.println( "Error running run3DJuryRes2v1_1_single:" + e );
			}
		}
	}
	

}
