import java.util.*;
import java.io.*;

/**
*Re number the ATOM coords in a PDB file so that it agrees with the sequence residue numbering
*
*/
public class renumberPDB
{
	Runtime r = Runtime.getRuntime();
	Process p = null;
	String sequence = "";
	String pdbfile = "";

	public renumberPDB( String AASequence, String PDBfile )
	{
		sequence = AASequence;
		pdbfile = PDBfile;
	}

	public String renumber()
	{
		String warning = "";
		try
		{
			if( (new File( pdbfile ) ).isDirectory() )
				System.out.println( pdbfile + " is a subdirectory." );
			
			if( !(new File( pdbfile ) ).isDirectory() )
			{
				//rename file if necessary i.e. parse out any spaces or brackets or weird characters!
				String subpdbfile = pdbfile.substring( pdbfile.lastIndexOf("/")+1 );
				//System.out.println( "Checking " + subpdbfile + "... " );
				StringBuffer subpdbfilebuf = new StringBuffer();
				for( int c = 0; c < subpdbfile.length(); c++ )
				{
					char c2 = subpdbfile.charAt( c );
					if( c2 == '0' || c2 == '1' || c2 == '2' || c2 == '3' || c2 == '4' || c2 == '5' || c2 == '6' || c2 == '7' || c2 == '8' || c2 == '9' ||
					c2 == 'a' || c2 == 'b' || c2 == 'c' || c2 == 'd' || c2 == 'e' || c2 == 'f' || c2 == 'g' || c2 == 'h' || c2 == 'i' || c2 == 'j' ||
					c2 == 'k' || c2 == 'l' || c2 == 'm' || c2 == 'n' || c2 == 'o' || c2 == 'p' || c2 == 'q' || c2 == 'r' || c2 == 's' || c2 == 't' ||
					c2 == 'u' || c2 == 'v' || c2 == 'w' || c2 == 'x' || c2 == 'y' || c2 == 'z' ||
					c2 == 'A' || c2 == 'B' || c2 == 'C' || c2 == 'D' || c2 == 'E' || c2 == 'F' || c2 == 'G' || c2 == 'H' || c2 == 'I' || c2 == 'J' ||
					c2 == 'K' || c2 == 'L' || c2 == 'M' || c2 == 'N' || c2 == 'O' || c2 == 'P' || c2 == 'Q' || c2 == 'R' || c2 == 'S' || c2 == 'T' ||
					c2 == 'U' || c2 == 'V' || c2 == 'W' || c2 == 'X' || c2 == 'Y' || c2 == 'Z' ||
					c2 == '-' || c2 == '_' || c2 == '~' || c2 == '.' )
						subpdbfilebuf.append( subpdbfile.charAt( c ) );
				}
				String subpdbfilenew = subpdbfilebuf.toString();
				//System.out.println( subpdbfilenew );
				if( !subpdbfile.equals( subpdbfilenew ) )
				{
					
					String[] mvfilt = {"/bin/bash", "-c", "/bin/mv \"" + pdbfile + "\" " + pdbfile.substring( 0, pdbfile.lastIndexOf("/")+1 ) + subpdbfilenew };
					p = r.exec( mvfilt );
					p.waitFor();
					p.destroy();
					warning = "Successfully renamed PDB file to "+ subpdbfilenew +" - illegal characters have now been removed.";
					pdbfile = pdbfile.substring( 0, pdbfile.lastIndexOf("/")+1 ) + subpdbfilenew;
					//System.out.println( "Successfully renamed PDB file to "+ subpdbfilenew +" - illegal characters have now been removed." );
				}
				
				Hashtable seqresHash = new Hashtable();
				//get sequence residue numbering
				for( int c = 0; c < sequence.length(); c++ )
				{
					char aa = sequence.charAt( c );
					String ssstr = convertToTLC( aa );
					seqresHash.put( new Integer( c+1 ), ssstr );
				}
				//System.out.println( seqresHash );
				//System.out.println( seqresHash.size() );
				
				//just look at ATOM records and filter file
				//get vector of original numbering
				Vector numberVect = new Vector();
				Vector checkresVect = new Vector();
				DataOutputStream outfilt = new DataOutputStream( new FileOutputStream( pdbfile + ".filt") );
				BufferedReader in = new BufferedReader( new FileReader( pdbfile ) );
				String line = in.readLine();
				if( line != null )
				{
					do
					{
						
						if( line.startsWith( "ATOM" ) && line.length() >= 54 )
						{
							
							//if( line.length() >= 60 )
							//{
							//	outfilt.writeBytes( line + "\n" );
							//}
							//Handle I-TASSER model files with no occupancy score column! Add in an occupancy score of 1.00 to all model files.
							//else if( line.length() < 60 )
							//{
								outfilt.writeBytes( line.substring( 0, 54 ) + "  1.00\n" );
							//}

							//String atomtype = line.substring(13, 17).trim();
							String atomtype = line.substring(12, 17).trim();
							String restype = line.substring(17, 20).trim();
							String resnumstr = line.substring(22, 26).trim();
							
							//System.out.println( line + "\n" + atomtype + " " + restype + " " + resnumstr );					
		
							Integer resnum = (new Integer(resnumstr));
							if( atomtype.equals("CA") && restype.length() == 3)
							{
								numberVect.addElement( resnum );
								checkresVect.addElement( restype );
							}
						}
						line = in.readLine();
					}
					while( line != null && !line.equals( "TER" ) );
				}
				in.close();
				outfilt.close();
				//System.out.println(numberVect);
				//System.out.println(checkresVect);
				//System.out.println(checkresVect.size());
	
	
				if( checkresVect.size() == 0 )
				{
					warning = warning + " WARNING: The full ATOM records could not be found. Are you sure this is a PDB file?";
					
					String[] rmfilt = {"/bin/bash", "-c", "/bin/rm " + pdbfile + ".filt" };
					p = r.exec( rmfilt );
					p.waitFor();
					p.destroy();
				}
	
				if( checkresVect.size() > 0 && checkresVect.size() <= seqresHash.size() )
				{
					String[] rmfilt = {"/bin/bash", "-c", "/bin/rm " + pdbfile };
					p = r.exec( rmfilt );
					p.waitFor();
					p.destroy();
					
					String[] mvfilt = {"/bin/bash", "-c", "/bin/mv " + pdbfile + ".filt " + pdbfile };
					p = r.exec( mvfilt );
					p.waitFor();
					p.destroy();
	
					//System.out.println( "Initial check passed - enough sequence residues for model. Checking numbering..." );
					
					//first check if numbering is OK and do nothing if it looks fine
					boolean numberingOK = true;
					for( int v = 0; v < checkresVect.size(); v++  )
					{
						String modrestype = (String)checkresVect.elementAt( v );
						Integer resnum = (Integer)numberVect.elementAt( v );
						String seqrestype = (String)seqresHash.get( resnum );
						//System.out.println(resnum + " " + modrestype + " " + seqrestype );
						if( !modrestype.equals( seqrestype ) )
							numberingOK = false;
					}
					if( numberingOK)
					{
						//System.out.println( "Numbering seems fine. Nothing to be done." );
					}
					
					if(!numberingOK)
					{
						//renumber file according to original numbering
						warning = warning + " Successfully renumbered PDB file according to sequence residue numbering.";
						
						//renumber vector
						boolean finished = false;
						int startres = 1;
						int initial_resnum = ((Integer)numberVect.elementAt( 0 )).intValue();
						int subtraction = initial_resnum-startres;
						while( !finished )
						//while( startres < 27 )
						{
							subtraction = initial_resnum-startres;
							//renumber res based on 
							numberingOK = true;
							for( int v = 0; v < checkresVect.size(); v++  )
							{
								String modrestype = (String)checkresVect.elementAt( v );
								int resnumint = ((Integer)numberVect.elementAt( v )).intValue();
								String seqrestype = (String)seqresHash.get( new Integer( resnumint-subtraction ) );
								//System.out.println( resnumint-subtraction + " " + modrestype + " " + seqrestype );
								if( !modrestype.equals( seqrestype ) )
									numberingOK = false;
							}
							
							//System.out.println( startres + " " + numberingOK + " " + subtraction);
	
							startres++;
							if( numberingOK )
								finished = true;
	
							if( startres == seqresHash.size() )
							{
								numberingOK = false;
								finished = true;
							}
							
						}
						//System.out.println( numberingOK + " " + subtraction);
	
						if( numberingOK )
						{
	
							//System.out.println(numberVect.size());
							
							Vector newnumberVect = new Vector();
							for( int v = 0; v < numberVect.size(); v++ )
							{
								int resnumint = ((Integer)numberVect.elementAt( v )).intValue();
								newnumberVect.addElement( new Integer(resnumint - subtraction) );
							}
							//System.out.println( newnumberVect );
							
							in = new BufferedReader( new FileReader( pdbfile ) );
							DataOutputStream out = new DataOutputStream( new FileOutputStream( pdbfile + ".brk2" ) );
							line = in.readLine();
							int currentresnumint = -1000000; //set to very low number as some PDB files start numbering at 0 or -1
							int res = 0;
							String origresnum = "";
							
							do
							{
								if( line.startsWith( "ATOM" ) )
								{
	
									String restype = line.substring(17, 20).trim();
									String resnumstr = line.substring(22, 26).trim();
	
									int resnumint = ( new Integer( resnumstr ) ).intValue();
									
									if( res < newnumberVect.size() )
									{
										if( resnumint > currentresnumint )
										{
											origresnum = String.valueOf( ( Integer )newnumberVect.elementAt( res ) );
	
											//add whitespace to get length correct
											String whitespace = "";
											for( int i = 0; i < 5-origresnum.length(); i++ )
												whitespace = whitespace + " ";
											origresnum = whitespace + origresnum;
											out.writeBytes( line.substring( 0, 21 ) + origresnum + line.substring(26) + "\n" );
											res++;
										}
									}
									if( resnumint == currentresnumint )
									{
										out.writeBytes( line.substring( 0, 21 ) + origresnum + line.substring(26) + "\n" );
									}
									
									currentresnumint = resnumint;
								}
								line = in.readLine();
							}
							while( line != null );
							in.close();
							out.close();
							
							Runtime r = Runtime.getRuntime();
							Process p = null;
							//System.out.println( "/bin/mv "+ outputdirectory + "/" + actualfilename + ".brk2 " + outputdirectory + "/" + actualfilename );
							String[] mv = {"/bin/bash", "-c", "/bin/mv " + pdbfile + ".brk2 " + pdbfile };
							p = r.exec( mv );
							p.waitFor();
							p.destroy();
							String[] rm = {"/bin/bash", "-c", "/bin/rm " + pdbfile + ".brk2" };
							p = r.exec( rm );
							p.waitFor();
							p.destroy();
	
						}
						if( !numberingOK )
						{
							warning = "WARNING: No score could be assigned. Unable to renumber residues for complete model. Please provide the full correct sequence.";
						}
					}
				}
	
				if( checkresVect.size() > 0 && seqresHash.size() < checkresVect.size() )
				{
					warning = "WARNING: No score could be assigned. The model has more residues than the sequence. Please provide the full correct sequence.";
					String[] rmfilt = {"/bin/bash", "-c", "/bin/rm " + pdbfile + ".filt" };
					p = r.exec( rmfilt );
					p.waitFor();
					p.destroy();
				}
			}
			
		}
		catch( Exception e )
		{
			System.err.println( e );
		}
		
		return warning;
	}
	
	public String convertToTLC( char aa )
        {
                String TLC = "";
                if( aa == 'A' )
                        TLC = "ALA";
                if( aa == 'B' )
                        TLC = "ASX";
                if( aa == 'C' )
                        TLC = "CYS";
                if( aa == 'D' )
                        TLC = "ASP";
                if( aa == 'E' )
                        TLC = "GLU";
                if( aa == 'F' )
                        TLC = "PHE";
                if( aa == 'G' )
                        TLC = "GLY";
                if( aa == 'H' )
                        TLC = "HIS";
                if( aa == 'I' )
                        TLC = "ILE";
                if( aa == 'K' )
                        TLC = "LYS";
                if( aa == 'L' )
                        TLC = "LEU";
                if( aa == 'M' )
                        TLC = "MET";
                if( aa == 'N' )
                        TLC = "ASN";
                if( aa == 'P' )
                        TLC = "PRO";
                if( aa == 'Q' )
                        TLC = "GLN";
                if( aa == 'R' )
                        TLC = "ARG";
                if( aa == 'S' )
                        TLC = "SER";
                if( aa == 'T' )
                        TLC = "THR";
                if( aa == 'V' )
                        TLC = "VAL";
                if( aa == 'W' )
                        TLC = "TRP";
                if( aa == 'X' )
                        TLC = "UNK";
                if( aa == 'Y' )
                        TLC = "TYR";
                if( aa == 'Z' )
                        TLC = "GLX";

                return TLC;

        }
	
	public static void main( String args[])
	{
		try
		{	renumberPDB rnpdb = new renumberPDB( args[0], args[1] );
			System.out.println( rnpdb.renumber() );
			
		}
		catch( Exception e )
		{
			System.err.println( e );
		}
	}
}