import java.util.*;
import java.io.*;

/**
*Manual TS refinement prediction pipeline for CASP9
*/
public class refineTS_CASP9
{	
	Runtime r = Runtime.getRuntime();
	Process p = null;
	
	public refineTS_CASP9( String target, String outputdirectory,  String TRtargetname )
	{
		try
		{	
			//make initial directories
			if( !( new File( outputdirectory + target ) ).exists() )
			{
				String[] mkdir = {"/bin/bash", "-c", "mkdir " + outputdirectory + target };
				System.out.println( "mkdir " + outputdirectory + target );
				p = r.exec( mkdir );
				p.waitFor();
				p.destroy();
				String[] mkdir2 = {"/bin/bash", "-c", "mkdir " + outputdirectory + target + "/uploaded_models/" };
				System.out.println( "mkdir " + outputdirectory + target + "/uploaded_models/" );
				p = r.exec( mkdir2 );
				p.waitFor();
				p.destroy();
			}
			
			//get server models and sequence
			if( !( new File( outputdirectory + target + "/" + target + ".fasta" ) ).exists() )
			{
				String[] wgetmod = {"/bin/bash", "-c", "wget http://predictioncenter.org/download_area/CASP9/server_predictions/"+target+".3D.srv.tar.gz -O " + outputdirectory + target+ "/" + target + ".3D.srv.tar.gz" };
				System.out.println( "wget http://predictioncenter.org/download_area/CASP9/server_predictions/"+target+".3D.srv.tar.gz -O " + outputdirectory + target + "/" + target + ".3D.srv.tar.gz" );
				p = r.exec( wgetmod );
				p.waitFor();
				p.destroy();
				String[] gunziptar = {"/bin/bash", "-c", "gunzip "+ outputdirectory + target + "/" + target + ".3D.srv.tar.gz;cd " + outputdirectory + target + "/;tar xf "+ outputdirectory + target + "/" + target + ".3D.srv.tar;cp " + outputdirectory + target + "/" + target + "/* "+ outputdirectory + target + "/uploaded_models/" };
				System.out.println( "gunzip "+ outputdirectory + target + "/" + target + ".3D.srv.tar.gz;cd " + outputdirectory + target + "/; tar xf "+ outputdirectory + target + "/" + target + ".3D.srv.tar;cp " + outputdirectory + target + "/" + target + "/* "+ outputdirectory + target + "/uploaded_models/" );
				p = r.exec( gunziptar );
				p.waitFor();
				p.destroy();				
				String[] wgetseq = {"/bin/bash", "-c", "wget \"http://predictioncenter.org/casp9/target.cgi?target="+target+"&view=sequence\" -O " + outputdirectory + target + "/" + target + ".fasta" };
				System.out.println( "wget \"http://predictioncenter.org/casp9/target.cgi?target="+target+"&view=sequence\" -O " + outputdirectory + target + "/" + target + ".fasta" );
				p = r.exec( wgetseq );
				p.waitFor();
				p.destroy();
				String[] wgetstartingmodel = {"/bin/bash", "-c", "wget \"http://www.predictioncenter.org/casp9/target.cgi?target="+TRtargetname+"&view=template\" -O " + outputdirectory + target+ "/"  + target + "/" + TRtargetname }; 
				System.out.println( "wget \"http://www.predictioncenter.org/casp9/target.cgi?target="+TRtargetname+"+&view=template\" -O " + outputdirectory + target + "/" + target + "/" + TRtargetname );
				p = r.exec( wgetstartingmodel );
				p.waitFor();
				p.destroy();
			}
			
			
			
			//Refine models 
			if( !( new File( outputdirectory + target + "/refined_models/" )).exists() )
			{
				String[] mkdir3 = {"/bin/bash", "-c", "mkdir " + outputdirectory + target + "/refined_models/" };
				System.out.println( "mkdir " + outputdirectory + target + "/refined_models/" );
				p = r.exec( mkdir3 );
				p.waitFor();
				p.destroy();
			
				//launch threaded version of run_i3Drefine_bfact_thread for 10 iterations
				run_i3Drefine_bfact_thread runi3Dref = new run_i3Drefine_bfact_thread( TRtargetname, (new Integer( 50 )).intValue(), outputdirectory + target + "/" + target + "/", outputdirectory + target + "/refined_models/" );
				runi3Dref.start();
						
				//wait until all models are finished
				boolean finished_refinement = false;

				while( !finished_refinement )
				{
					if( new File(outputdirectory + target + "/refined_models/").list().length == 50 )
						finished_refinement = true;
						
					Thread.sleep(10000);//sleep for 10 seconds
				}		
				
				//copy original model file too into /refined_models/
				System.out.println( "cp " + outputdirectory + target + "/" + target + "/" + TRtargetname + " " + outputdirectory + target + "/refined_models/" );
				String[] cp = {"/bin/bash", "-c", "cp " + outputdirectory + target + "/" + target + "/" + TRtargetname + " " + outputdirectory + target + "/refined_models/" };
				p = r.exec( cp );
				p.waitFor();
				p.destroy();

			}
			
			//Phase2: run ModFOLDclust_single_bfact_mod on pool of refined models versus server models
			if( ( new File( outputdirectory + target + "/refined_models/" )).exists() && !( new File( outputdirectory + target + "/refined_models_bfact/" )).exists() )
			{
				String[] mkdir4 = {"/bin/bash", "-c", "mkdir " + outputdirectory + target + "/refined_models_bfact/" };
				System.out.println( "mkdir " + outputdirectory + target + "/refined_models_bfact/" );
				p = r.exec( mkdir4 );
				p.waitFor();
				p.destroy();
				
				ModFOLDclust_single_bfact_mod mFLD = new ModFOLDclust_single_bfact_mod( target,  outputdirectory + target + "/" + target + ".fasta", outputdirectory + target + "/uploaded_models/", outputdirectory + target + "/refined_models/" , outputdirectory + target + "/refined_models_bfact/" );
				
				//mv all of the refined b-factor files into main directory
				System.out.println( "cp " + outputdirectory + target + "/refined_models_bfact/* " + outputdirectory + target + "/" + target + "/" );
				String[] cp = {"/bin/bash", "-c", "cp " + outputdirectory + target + "/refined_models_bfact/* " + outputdirectory + target + "/" + target + "/" };
				p = r.exec( cp );
				p.waitFor();
				p.destroy();
			}	
			
				
			//Phase2 models: get top 5 models (whether from refined batch or not)
			if( ( new File( outputdirectory + target + "/uploaded_models/tmp.out/" + target + "_ModFOLDclust_single.sort" ) ).exists() )
			{
			
				StringBuffer messagebuf = new StringBuffer();
				messagebuf.append( "PFRMAT TS\n");
				messagebuf.append( "TARGET "+TRtargetname+"\n");
				messagebuf.append( "AUTHOR 4107-9225-6039\n");
				messagebuf.append( "METHOD Alternative refined models are built using i3Drefine and then the ModFOLDclust_single method is used to rank models and add B-factor predictions.\n");
				StringBuffer finalmodelsbuf = new StringBuffer();
				
				BufferedReader in2 = new BufferedReader( new FileReader( outputdirectory + target + "/uploaded_models/tmp.out/" + target + "_ModFOLDclust_single.sort" ) );
				
				String line2 = in2.readLine();
				int numrefmod = 1;
				do
				{
					StringTokenizer linetoks2 = new StringTokenizer(line2);
					String refinedfile = linetoks2.nextToken();
					String score = linetoks2.nextToken();
					System.out.println( refinedfile + " " + score );
					
					File refinedmodel = new File( outputdirectory + target + "/" + target + "/" + refinedfile + ".bfact" );
						
					if( refinedmodel.exists() )
 					{
						messagebuf.append( "MODEL " +numrefmod+ "\n" );
						messagebuf.append( "REMARK 1 starting model: "+refinedfile+"\n" );
						messagebuf.append( "PARENT N/A\n" );
						messagebuf.append( "SCORE "+score+"\n");
						
						BufferedReader modin = new BufferedReader( new FileReader( outputdirectory + target + "/" + target + "/" + refinedfile + ".bfact" ) );
						String modline = modin.readLine();
						do
						{
							//System.out.println( modline );
							if( modline.startsWith( "ATOM" ) || modline.startsWith( "HETATM" ) )
							{	
								modline = modline.replaceAll( "'", " " );
								
								String occupancy = modline.substring(56, 61).trim();
								
								//check occupancy
								if( occupancy.startsWith( "1." ) )
									messagebuf.append( modline.substring( 0, 66 ).trim() + "\n" );
									
								else if( !occupancy.startsWith( "1." ) )
								{
									messagebuf.append( modline.substring( 0, 56 ) + "1.00" + modline.substring( 60,66 ).trim() + "\n" );
								}
							}
							
							else
							{
								messagebuf.append( modline + "\n" );
							}
							
							modline = modin.readLine();
						}
						while( modline != null );
						modin.close();
						
						if(!messagebuf.toString().endsWith("TER\nEND\n"))
							messagebuf.append( "END\n" );
						
						//add to list of final models
						finalmodelsbuf.append(refinedfile+".bfact\n");
						
					}
					line2 = in2.readLine();
					numrefmod++;
				}
				while( numrefmod < 6 && line2 != null );
				in2.close();
				
				DataOutputStream out = new DataOutputStream( new FileOutputStream( outputdirectory + target + "/" + target + "/" + TRtargetname + "_TSr.txt" ) );
				out.writeBytes( messagebuf.toString() );
				out.close();
		
				//output list of final models
				DataOutputStream finalmodelout = new DataOutputStream( new FileOutputStream( outputdirectory + target + "/" + target + "/" + TRtargetname +"_finalmodels.txt" ) );
				finalmodelout.writeBytes( finalmodelsbuf.toString() );
				finalmodelout.close();
				
			}
			
			//send email (if not benchmarking)
// 			if( new File( outputdirectory + target + "/" + target + "/" + TRtargetname + "_TSr.txt" ).exists() )
// 			{
// 				StringBuffer messagebuf = new StringBuffer();
// 				BufferedReader in = new BufferedReader( new FileReader( outputdirectory + target + "/" + target + "/" + TRtargetname + "_TSr.txt" ) );
// 				String line = in.readLine();
// 				do
// 				{
// 					messagebuf.append( line + "\n" );
// 					line = in.readLine();
// 				}
// 				while( line != null );
// 				in.close();
// 				String message = messagebuf.toString();
// 				SendMail sm = new SendMail( "models@predictioncenter.org", "McGuffin_manual<l.j.mcguffin@reading.ac.uk>", "McGuffin group results for target sequence " + TRtargetname + ".", message, "mailhost.rdg.ac.uk");
// 			}
			
			
		}

		catch( Exception e )
		{
			System.out.println( "Error executing manualTS_CASP9!\n" + e );
		}

	}

	public static void main( String args[])
	{
		try
		{
			refineTS_CASP9 mTS = new refineTS_CASP9( args[0], args[1], args[2] );
		}
		catch( Exception e )
		{
			System.err.println( e );
		}
	}
}
