package meshi.optimizers;
import meshi.energy.*;
import meshi.energy.pairwiseNonBondedTerms.LennardJones.*;
import meshi.molecularElements.*;
import meshi.util.*;
import meshi.util.string.*;
import java.util.*;

/**
 * Minimize energy according to a given set of coordinates and an energy function
 *
 **/

public abstract class Optimizer {
    public final TotalEnergy energy;
    public final int maxSteps;
    public final int reportEvery;
    public static final Terminator optimizerTerminator = new Terminator();
    public enum OptimizerStatus {RUNNING,CONVERGED, UNCONVERGED, KILLED, DONE;}
    public Optimizer(TotalEnergy energy, int maxSteps, int reportEvery) {
	this.maxSteps = maxSteps;
	this.energy = energy;
	this.reportEvery = reportEvery;
	optimizerTerminator.reset();
    }
    public TotalEnergy energy() {return energy;}
    public abstract OptimizerStatus run() throws OptimizerException;
}
