package meshi.energy.RG;
import meshi.energy.*;
import meshi.molecularElements.*;
import meshi.molecularElements.atoms.*;
import meshi.geometry.*;
import meshi.util.string.*;
import java.util.*;
import meshi.util.*;

/**
 *An implicit solvation energy term for all-atom models, modeling a 4.0 angs solvation shell around
 *each atom.
 **/

public class RgCreator extends EnergyCreator  implements KeyWords {
        
    public RgCreator(double weight) {
	super(weight);
    }

    public RgCreator() {
	super(1.0);
    }


    public AbstractEnergy createEnergyTerm(Protein protein, DistanceMatrix distanceMatrix, 
					  CommandList commands) {
		return new RgEnergy(protein.atoms().filter(new AtomList.BackboneFilter()), distanceMatrix, weight());
    }

}
