#!/usr/bin/perl -w
############################################################################
#
#i3Drefine software for protein 3D structure refinement
#configure.pl: to configure the installation of i3Drefine
#
#Author: Debswapna Bhattacharya
#Department of Computer Science
#Informatics Institute
#University of Missorui, Columbia
#
#References:
#1. Bhattacharya. D, Cheng. J.  i3Drefine software for protein 3D structure 
#refinement. PLoS ONE (submitted)
#2. Bhattacharya. D, Cheng. J.  3Drefine: Consistent protein structure 
#refinement by optimizing hydrogen bonding network and atomic-level energy 
#minimization.Proteins. DOI: 10.1002/prot.24167
##############################################################################

####################### Customize settings here ##############################

#set installation directory of i3Drefine to your unzipped i3Drefine directory
#$install_dir = "/home/db279/3DRefine";
####################### End of Customizaton ##################################
#check if the root directory is right
#the configuration file must run in the root directory
$cur_dir = `pwd`;  
chomp $cur_dir; 
$configure_file = "$cur_dir/configure.pl";
$install_dir = "$cur_dir/";

########################## Don't Change the code below #######################

if (! -d $install_dir)
{
	die "can't find installation directory.\n";
}
if ( substr($install_dir, length($install_dir) - 1, 1) ne "/" )
{
	$install_dir .= "/"; 
}



if (! -f $configure_file)
{
	die "Please configure i3Drefine from the  root of i3Drefine directory.\n";
}

$bin_dir = "${install_dir}bin/";
$script_dir = "${install_dir}script/";
$software_dir = "${install_dir}software/";
$refine_dir = "${install_dir}software/3Drefine/";
$test_dir = "${install_dir}test/";


if ( ! -d $bin_dir || ! -d $script_dir || ! -d $software_dir || ! -d $refine_dir || ! -d $test_dir )
{
	die "Some sub directories don't exist. Please check the installation tar ball.\n";
}



#sets the relevant paths
$dssp_exe = "${software_dir}DSSP/dssp";
$cmd_exe = "${refine_dir}Commands";

if (! -f $dssp_exe)
{
	die "Please download the DSSP program and place it in ${software_dir}DSSP directory with the name dssp.\n";
}

############################ Generate Shell Script For user ##############################

#generate script of creating alignment for one sequence
open(SHELL, ">${bin_dir}i3Drefine.sh") || die "can't create i3Drefine script\n";
print SHELL "#!/bin/sh\n";
print SHELL "if [ \$# -ne 2 ]\n";
print SHELL "then\n\techo \"need two parameters: in_pdb, Num.\" \n\texit 1\nfi\n";
print SHELL "${script_dir}i3Drefine.pl $dssp_exe $cmd_exe \$1 \$2\n";
close SHELL; 

#generate the parameter file needed by MESHI
open(PARM, ">${refine_dir}Commands") || die "can't create paramter file for MESHI.\n";
print PARM "parameters ${refine_dir}parameters\n";
print PARM "#\n";
print PARM "#\n";
print PARM "# Weights for the energy terms\n";
print PARM "bondEnergy weight 0.10\n";
print PARM "LennardJonesCa weight 0.2\n";
print PARM "LennardJones weight 0.00\n";
print PARM "angleEnergy weight 2.0\n";
print PARM "planeEnergy weight 10.0\n";
print PARM "twoTorsionsEnergy weight 1.0\n";
print PARM "flatRamachEnergy weight 6\n";
print PARM "propensityTorsionEnergy weight 1.0\n";
print PARM "solvateEnergy weight 10.0\n";
print PARM "outOfPlaneEnergy weight 100.0\n";
print PARM "alphaAngleEnergy weight 1.0 \n";
print PARM "alphaTorsionEnergy weight 1.0 \n";
print PARM "hydrogenBonds weight 0.001\n";
print PARM "hydrogenBondsPairs weight 0.1\n";
print PARM "hydrogenBondsPlane weight 0\n";
print PARM "hydrogenBondsAngles weight 100\n";
print PARM "cAlphaHydrogenBonds weight 0.0\n";
print PARM "cAlphaHOtorsins weight 0.0\n";
print PARM "tetherEnergy weight 10.0\n";
print PARM "templateEnergy weight 10.0\n";
print PARM "electrostatics weight 0.1\n";
print PARM "electrostatics dielectricConstant 4\n";
print PARM "ramachandranSidechain weight 10\n";
print PARM "atomicPairwisePMFSumma weight 1\n";
print PARM "compositePropensity weight 10\n";
print PARM "\n";
print PARM "# Inflate parameters\n";
print PARM "inflateEnergy weight 0.1\n";
print PARM "inflateEnergy RmsTarget 1\n";
print PARM "\n";
print PARM "\n";
print PARM "# Minimization parameters - full minimization\n";
print PARM "minimize maxSteps 200000\n";
print PARM "minimize tolerance 0.1\n";
print PARM "minimize reportEvery 200\n";
print PARM "\n";
print PARM "# Minimization parameters - short relaxation\n";
print PARM "relax tolerance 0.1\n";
print PARM "relax maxSteps 6000\n";
print PARM "relax reportEvery 200\n";
print PARM "\n";
print PARM "# MCM parameters\n";
print PARM "mcmPerturbation tolerance 0.01\n";
print PARM "mcmPerturbation maxSteps 200000\n";
print PARM "mcmPerturbation reportEvery 200\n";
print PARM "MCM initialTemperature 10\n";
print PARM "MCM finalTemperature 0.01\n";
print PARM "MCM maxSteps 10\n";
print PARM "\n";
print PARM "\n";
print PARM "# This command tels the program to use our approximated arcCosinus which is ~4 times \n";
print PARM "# faster than the one in the StrictMath library. \n";
print PARM "useFastArcCos\n";
print PARM "dresserFragments fragments5.txt\n";
print PARM "rotamerLibrary bbdep02.May.sortlib\n";
print PARM "\n";
print PARM "#Misc.\n";
print PARM "seed 4\n";
print PARM "corpusFileName parameters/finalCorpus.txt\n";
print PARM "maxRunTime 10000\n";


`chmod 755 ${bin_dir}*.sh`;
`chmod 755 ${script_dir}*`;
`chmod 755 ${software_dir}*`;
`chmod 755 ${software_dir}/DSSP/*`;