import java.util.*;
import java.io.*;

/**
*ModFOLDclust_single - force single model mode - compare individual uploaded models against the IntFOLD2-TS 3D models using ModFOLDclust
*/
public class ModFOLDclust_single_bfact_mod
{	
	Runtime r = Runtime.getRuntime();
	Process p = null;
	String errStr = "";
	
	public ModFOLDclust_single_bfact_mod( String target, String fastafile, String outputdirectory, String uploadedmodelsdirectory, String bfact_outputdirectory )
	{
		try
		{
			//read fasta file to get email and targetname
			BufferedReader fastain = new BufferedReader( new FileReader( fastafile  ) );
			String fastaline = fastain.readLine();
			
			String sequence = "";
			fastaline = fastain.readLine();
			do
			{
				sequence = sequence + fastaline;
				fastaline = fastain.readLine();
			}
			while( fastaline != null );

			//check sequence
			//sequence must be all upper case letters....
			sequence = sequence.toUpperCase();
			//check all characters are all uppercase letters
			boolean stop = false;
			boolean sequence_is_bunk = false;
			int l = 0;
			char aa = ' ';
			do
			{
				aa = sequence.charAt(l);
	
				if( ! Character.isLetter(aa) || ! Character.isUpperCase(aa) )
				{
					stop = true;
					sequence_is_bunk = true;
				}
				l++;
	
				if( l == sequence.length() )
					stop = true;
	
			}
			while( stop == false );

			if( sequence_is_bunk )
				System.out.println( "Could not read sequence file." );

			if( !sequence_is_bunk )
			{
				System.out.println( "Running ModFOLDclust_single...\nChecking uploaded model files..." );
				//go through directory try to renumber pdb files and mv dodgy files into tmp directory
				//read input directory and find pdb files
				File direct = new File( uploadedmodelsdirectory );
				String directory[] = direct.list();
				StringBuffer errorbuf = new StringBuffer();
				StringBuffer rejectedfilesbuf = new StringBuffer();
				String[] mkdir = {"/bin/bash", "-c", "/bin/mkdir " + outputdirectory + "/tmp.out/" };
				p = r.exec( mkdir );
				p.waitFor();
				p.destroy();
				for( int i = 0; i < directory.length; i++ )
				{
					String actualfilename = directory[i];
	
					//renumber file and get error messages
					renumberPDB rnpdb = new renumberPDB( sequence, uploadedmodelsdirectory + "/" + actualfilename );
					String errormsg = rnpdb.renumber();
					
					if( errormsg.startsWith( "Successfully renamed PDB file to " ) )
					{
						actualfilename = errormsg.substring( 33,  errormsg.indexOf(" - illegal characters have now been removed.") );
					}
						
					if( errormsg.contains( "WARNING" ) )
					{
						errorbuf.append( "REMARK ERROR FOR MODEL: " + actualfilename + " - " + errormsg + "\n" );
						System.out.println( "WARNING - ERROR FOR MODEL: " + actualfilename + " - " + errormsg );
						rejectedfilesbuf.append( actualfilename + " X\n");
						System.out.println( "Moving offending file " + actualfilename + " to " + outputdirectory + "/tmp.out/" );
 						String[] mv2 = {"/bin/bash", "-c", "/bin/mv " + uploadedmodelsdirectory + "/" + actualfilename + " " + outputdirectory + "/tmp.out/" };
						p = r.exec( mv2 );
						p.waitFor();
						p.destroy();
					}
					if( errormsg.startsWith( "Successfully" ) )
					{
						errorbuf.append( "REMARK MODEL: " + actualfilename + " - " + errormsg + "\n" );
					}
				}

				System.out.println( "Clustering using ModFOLDclust_single_bfact..." );
				new run3DJuryRes2v1_1_single_bfact_mod( outputdirectory, uploadedmodelsdirectory, target, sequence, bfact_outputdirectory );
				
				//sort list
				String[] sort = {"/bin/bash", "-c", "sort -g -r -k 2 "+outputdirectory + "/"+target+"_ModFOLDclust_single.unsort > " +outputdirectory + "/tmp.out/"+target+"_ModFOLDclust_single.sort;rm "+outputdirectory + "/"+target+"_ModFOLDclust_single.unsort"};
				p = r.exec( sort );
				p.waitFor();
				p.destroy();	
				
				DataOutputStream out = new DataOutputStream( new FileOutputStream( outputdirectory + "/tmp.out/"+target+"_ModFOLDclust_single.out" ) );
				
				//print header
				out.writeBytes( "PFRMAT QA\n" );
				out.writeBytes( "TARGET "+target+"\n" );
				out.writeBytes( "AUTHOR Liam J. McGuffin\n" );
				
				errStr = errorbuf.toString();
				if( errStr.length() > 0 )
				{
					out.writeBytes( errStr );
				}
				
				out.writeBytes( "METHOD ModFOLDclust in single-model mode.\n" );
				out.writeBytes( "MODEL 1\n" );
				out.writeBytes( "QMODE 2\n" );
				
				//output sorted scores
				BufferedReader in = new BufferedReader( new FileReader(outputdirectory + "/tmp.out/"+target+"_ModFOLDclust_single.sort" ) );
				String line = in.readLine();
				String subline = "";
				do
				{
					//break up line into columns of 100 characters
					StringTokenizer linetoks = new StringTokenizer(line);
					subline = linetoks.nextToken();//model name
					
					while( linetoks.hasMoreTokens() )
					{
						if( subline.length() <= 90 )
						{
							subline = subline + " " + linetoks.nextToken();
						}
						
						if(subline.length() > 90)
						{
							out.writeBytes( subline.trim() + "\n" );
							subline = "";
						}
					}
					if( !subline.equals("") && subline.length() <= 90)
					{
						out.writeBytes( subline.trim() + "\n" );
						subline = "";
					}
					
					line = in.readLine();
				}
				while( line != null );
				in.close();
				
				//output footer
				if( rejectedfilesbuf.toString().length() > 0 )
					out.writeBytes( rejectedfilesbuf.toString() );
				out.writeBytes( "END\n" );
				out.close();
			}	
		}

		catch( Exception e )
		{
			System.out.println( "Error executing ModFOLDclust_single_bfact!\n" + e );
		}

	}
	
	public String getErrors()
	{
		return errStr;
	}

	public static void main( String args[])
	{
		try
		{
			if( args.length == 4 )
			{
				ModFOLDclust_single_bfact_mod mFLD = new ModFOLDclust_single_bfact_mod( args[0], args[1], args[2], args[3], args[4] );
			}	

		}
		catch( Exception e )
		{
			System.err.println( e );
		}
	}
}
