/*
 * Decompiled with CFR 0.152.
 */
package jbcl.util;

import jbcl.datatypes.Vector3D;

public class Format {
    private static final String[] empty_strings = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          ", "           ", "            ", "             ", "              ", "               ", "                ", "                 ", "                  ", "                   ", "                    ", "                     ", "                      ", "                       ", "                        ", "                         ", "                          ", "                           "};
    private static final String[] zeros = new String[]{"", "0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000", "0000000000", "00000000000"};

    public static String format(int n, int n2) {
        String string = Integer.toString(n);
        int n3 = n2 - string.length();
        if (n3 > 0) {
            return empty_strings[n3] + string;
        }
        return string;
    }

    public static String formatZero(int n, int n2) {
        String string = Integer.toString(n);
        int n3 = n2 - string.length();
        if (n3 > 0) {
            return zeros[n3] + string;
        }
        return string;
    }

    public static String formatLeft(String string, int n) {
        int n2 = n - string.length();
        if (n2 > 0) {
            return string + empty_strings[n2];
        }
        return string;
    }

    public static String formatRight(String string, int n) {
        int n2 = n - string.length();
        if (n2 > 0) {
            return empty_strings[n2] + string;
        }
        return string;
    }

    public static String format(double d, int n, int n2) {
        String string;
        String string2 = Math.abs(d) < 0.001 ? "0.0" : Double.toString(d);
        int n3 = string2.indexOf(46);
        if (n3 == -1) {
            n3 = string2.length();
            string = "";
        } else {
            string = string2.substring(n3 + 1);
        }
        int n4 = n2 - string.length();
        if (n4 > 0) {
            string = string.concat(zeros[n4]);
        } else if (n4 < 0) {
            string = string.substring(0, string.length() + n4);
        }
        String string3 = string2.substring(0, n3);
        n4 = n - string3.length();
        if (n4 > 0) {
            return empty_strings[n4] + string3 + "." + string;
        }
        return string3 + "." + string;
    }

    public static String format(Vector3D vector3D, int n, int n2) {
        return Format.format(vector3D.x, n, n2) + " " + Format.format(vector3D.y, n, n2) + Format.format(vector3D.z, n, n2);
    }

    public static String format(int[] nArray, int n, String string) {
        String string2 = "";
        for (int i = 0; i < nArray.length; ++i) {
            String string3 = Integer.toString(nArray[i]);
            int n2 = n - string3.length();
            string2 = n2 > 0 ? string2 + empty_strings[n2] + string3 + string : string2 + string3 + string;
        }
        return string2;
    }

    public static String format(double[] dArray, int n, int n2, String string) {
        String string2 = "";
        for (int i = 0; i < dArray.length; ++i) {
            string2 = string2 + Format.format(dArray[i], n, n2) + string;
        }
        return string2;
    }
}

