/*
 * Decompiled with CFR 0.152.
 */
package jbcl.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;

public class CmdArgs {
    public static String DELIMITER = "=";
    public static String EMPTY_VALUE = null;
    public static String VALUES_DELIMITER = ",";
    public static char FLAG_PREFIX = (char)45;
    public static char FILE_PREFIX = (char)64;
    public static String RANGE_DELIMITER = ":";
    private String[] valid_flags;
    private HashMap flags;
    private static int MAX_VALUES = 100000;
    private static int[] buffer = new int[MAX_VALUES];

    public CmdArgs(String[] stringArray) {
        this.valid_flags = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.valid_flags[i] = new String(stringArray[i]);
        }
        this.flags = new HashMap(stringArray.length);
        Arrays.sort(this.valid_flags);
    }

    public void printValidFlags() {
        for (int i = 0; i < this.valid_flags.length; ++i) {
            System.out.println(this.valid_flags[i]);
        }
    }

    public void printGivenFlags() {
        System.out.println(this.flags);
    }

    public void parse(String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                this.addFlag(string2);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    public void parse(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            if (stringArray[i].charAt(0) == FILE_PREFIX) {
                this.parse(stringArray[i].substring(1));
                continue;
            }
            this.addFlag(stringArray[i]);
        }
    }

    public boolean hasFlag(String string) {
        return this.flags.containsKey(string);
    }

    public void addFlag(String string, String string2) {
        if (string.charAt(0) == FLAG_PREFIX) {
            this.isValidFlag(string);
            this.flags.put(string, string2);
        }
    }

    public void addFlag(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITER);
        String string2 = stringTokenizer.nextToken();
        if (string2.charAt(0) != FLAG_PREFIX) {
            return;
        }
        this.isValidFlag(string2);
        String string3 = EMPTY_VALUE;
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        this.flags.put(string2, string3);
    }

    public int getIntValue(String string) {
        return Integer.parseInt((String)this.flags.get(string));
    }

    public long getLongValue(String string) {
        return Long.parseLong((String)this.flags.get(string));
    }

    public String getStringValue(String string) {
        return (String)this.flags.get(string);
    }

    public double getDoubleValue(String string) {
        return Double.parseDouble((String)this.flags.get(string));
    }

    public double[] getDoubleArray(String string) {
        String string2 = (String)this.flags.get(string);
        if (string2 == EMPTY_VALUE) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, VALUES_DELIMITER);
        double[] dArray = new double[stringTokenizer.countTokens()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.parseDouble(stringTokenizer.nextToken());
        }
        return dArray;
    }

    public int[] getIntArray(String string) {
        String string2 = (String)this.flags.get(string);
        if (string2 == EMPTY_VALUE) {
            return null;
        }
        buffer = new int[MAX_VALUES];
        int n = 0;
        String[] stringArray = string2.split(VALUES_DELIMITER);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf(RANGE_DELIMITER) > 0) {
                String[] stringArray2 = stringArray[i].split(RANGE_DELIMITER);
                int n2 = Integer.parseInt(stringArray2[0]);
                int n3 = Integer.parseInt(stringArray2[1]);
                int n4 = n2;
                while (n4 <= n3) {
                    CmdArgs.buffer[n] = n4++;
                    ++n;
                }
                continue;
            }
            CmdArgs.buffer[n] = Integer.parseInt(stringArray[i]);
            ++n;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = buffer[i];
        }
        return nArray;
    }

    public String[] getStringArray(String string) {
        String string2 = (String)this.flags.get(string);
        if (string2 == EMPTY_VALUE) {
            return null;
        }
        String[] stringArray = string2.split(VALUES_DELIMITER);
        return stringArray;
    }

    public boolean hasValue(String string) {
        if (!this.hasFlag(string)) {
            return false;
        }
        String string2 = (String)this.flags.get(string);
        return string2 != EMPTY_VALUE;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-int=5", "-double_array=1.0,1.4,1.6", "-double=-9.13", "-int_array=1,-2,4:7"};
        String[] stringArray3 = new String[]{"-int", "-double", "-double_array", "-int_array"};
        System.out.println("Input strings:");
        for (int i = 0; i < stringArray2.length; ++i) {
            System.out.println("\"" + stringArray2[i] + "\"");
        }
        CmdArgs cmdArgs = new CmdArgs(stringArray3);
        cmdArgs.parse(stringArray2);
        System.out.println("data for flag -int : " + cmdArgs.getIntValue("-int"));
        System.out.println("data for flag -double : " + cmdArgs.getDoubleValue("-double"));
        System.out.print("data for flag -double_array : ");
        double[] dArray = cmdArgs.getDoubleArray("-double_array");
        for (int i = 0; i < dArray.length; ++i) {
            System.out.print(dArray[i] + " ");
        }
        System.out.println();
        System.out.println("data for flag -int_array : ");
        int[] nArray = cmdArgs.getIntArray("-int_array");
        for (int i = 0; i < dArray.length; ++i) {
            System.out.print(nArray[i] + " ");
        }
        System.out.println();
    }

    private boolean isValidFlag(String string) {
        if (Arrays.binarySearch(this.valid_flags, string) < 0) {
            System.err.println("CmdArgs::isValidFlag: Invalid flag was used: " + string);
            System.exit(0);
        }
        return true;
    }
}

