/*
 * Decompiled with CFR 0.152.
 */
package jbcl.util;

public class AaCodes {
    public static int MAX_ATOMS_IN_LIGAND = 100;
    private static String[] backbone_atoms = new String[]{" N  ", " CA ", " C  ", " O  "};
    private static String[] aa_name3 = new String[]{"GLY", "ALA", "SER", "CYS", "VAL", "THR", "ILE", "PRO", "MET", "ASP", "ASN", "LEU", "LYS", "GLU", "GLN", "ARG", "HIS", "PHE", "TYR", "TRP", "UNK", "  A", "  C", "  G", "  T", "  U", "   ", "err"};
    private static char[] aa_name = new char[]{'G', 'A', 'S', 'C', 'V', 'T', 'I', 'P', 'M', 'D', 'N', 'L', 'K', 'E', 'Q', 'R', 'H', 'F', 'Y', 'W', 'X', 'a', 'c', 't', 'g', 'u', '_', 'e'};
    private static int[] aa_atoms = new int[]{4, 5, 6, 6, 7, 7, 8, 7, 8, 8, 8, 8, 9, 9, 9, 11, 10, 11, 12, 14, 14, 0, 0, 0, 0, 0, 0, MAX_ATOMS_IN_LIGAND};
    private static double[] aa_frequency = new double[]{0.0812534, 0.015224, 0.051838, 0.061934, 0.0399081, 0.0697054, 0.0230206, 0.0570292, 0.0538776, 0.0979475, 0.0235526, 0.0421775, 0.0504655, 0.0400321, 0.0553755, 0.0715385, 0.0561607, 0.0655387, 0.0132152, 0.030206, 0.0, 0.0};
    private static double[] kd_scale = new double[]{-0.4, 1.8, -0.8, 2.5, 4.2, -0.7, 4.5, -1.6, 1.9, -3.5, -3.5, 3.8, -3.9, -3.5, -3.5, -4.5, -3.2, 2.8, -1.3, -0.9, 0.0, 0.0};

    public static byte aaIndex(char c) {
        byte by = -1;
        while (aa_name[by = (byte)((byte)(by + 1))] != c && by < 27) {
        }
        return by;
    }

    public static byte aaIndex(String string) {
        byte by = -1;
        while (aa_name3[by = (byte)((byte)(by + 1))].compareTo(string) != 0 && by < 27) {
        }
        return by;
    }

    public static char aaName(byte by) {
        return aa_name[by];
    }

    public static String aaName3(byte by) {
        return aa_name3[by];
    }

    public static String aaName3(char c) {
        return aa_name3[AaCodes.aaIndex(c)];
    }

    public static char aaName(String string) {
        return aa_name[AaCodes.aaIndex(string)];
    }

    public static int nAtoms(byte by) {
        return aa_atoms[by];
    }

    public static byte ssIndex(char c) {
        switch (c) {
            case 'H': {
                return 2;
            }
            case 'T': {
                return 2;
            }
            case 'E': {
                return 4;
            }
            case 'B': {
                return 4;
            }
            case 'S': {
                return 4;
            }
        }
        return 1;
    }

    public static char ssLetter(byte by) {
        switch (by) {
            case 2: {
                return 'H';
            }
            case 4: {
                return 'E';
            }
        }
        return 'C';
    }

    public static double aaFrequency(byte by) {
        return aa_frequency[by];
    }

    public static double scaleKD(byte by) {
        return kd_scale[by];
    }

    public static byte aaTestHP(byte by) {
        switch (by) {
            case 0: {
                return 2;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 2;
            }
            case 8: {
                return 2;
            }
            case 9: {
                return 1;
            }
            case 10: {
                return 1;
            }
            case 11: {
                return 2;
            }
            case 12: {
                return 1;
            }
            case 13: {
                return 1;
            }
            case 14: {
                return 1;
            }
            case 15: {
                return 1;
            }
            case 16: {
                return 1;
            }
            case 17: {
                return 2;
            }
            case 18: {
                return 1;
            }
            case 19: {
                return 1;
            }
        }
        return 2;
    }

    public static void main(String[] stringArray) {
        byte by;
        System.out.println("Amino acids:");
        for (by = 0; by < 21; by = (byte)(by + 1)) {
            System.out.println(AaCodes.aaName(by) + " => " + AaCodes.aaName3(by) + " (index=" + AaCodes.aaIndex(AaCodes.aaName(by)) + ") kd=" + AaCodes.scaleKD(by));
        }
        System.out.println("Bases:");
        for (by = 21; by < 26; by = (byte)(by + 1)) {
            System.out.println(AaCodes.aaName(by) + " => " + AaCodes.aaName3(by) + " (index=" + AaCodes.aaIndex(AaCodes.aaName(by)) + ")");
        }
    }
}

