/*
 * Decompiled with CFR 0.152.
 */
package jbcl.statistics;

import jbcl.statistics.Histogram;

public class WeightedHistogram
extends Histogram {
    public WeightedHistogram(int n, double d, double d2) {
        super(n, d, d2);
    }

    public WeightedHistogram(double[] dArray, int n) {
        super(dArray, n);
    }

    public WeightedHistogram(double[] dArray, double[] dArray2, int n) {
        int n2;
        int n3 = dArray.length;
        this.m_min = this.m_max = dArray[0];
        this.m_entries = 0;
        for (n2 = 1; n2 < n3; ++n2) {
            if (this.m_min > dArray[n2]) {
                this.m_min = dArray[n2];
            }
            if (!(this.m_max < dArray[n2])) continue;
            this.m_max = dArray[n2];
        }
        this.m_nbins = n;
        this.m_hist = new double[this.m_nbins];
        this.m_underflow = 0.0;
        this.m_overflow = 0.0;
        this.bin_width = (this.m_max - this.m_min) / (double)this.m_nbins;
        for (n2 = 0; n2 < n3; ++n2) {
            this.insert(dArray[n2], dArray2[n2]);
        }
    }

    public void insert(double d, double d2) {
        if (d < this.m_min) {
            this.m_underflow += 1.0;
            return;
        }
        if (d > this.m_max) {
            this.m_overflow += 1.0;
            return;
        }
        int n = this.findBin(d);
        this.m_hist[n] = this.m_hist[n] + d2;
        this.m_entries = (int)((double)this.m_entries + d2);
    }

    public void insert(double[] dArray, double[] dArray2) {
        for (int i = 0; i < dArray.length; ++i) {
            this.insert(dArray[i], dArray2[i]);
        }
    }
}

