/*
 * Decompiled with CFR 0.152.
 */
package jbcl.statistics;

import jbcl.datatypes.Multicolumn;

public class VarianceOfBlocks {
    public static void calculate(double[] dArray, double[] dArray2) {
        int n;
        int n2 = dArray2.length;
        int n3 = dArray.length;
        double d = 0.0;
        for (n = 0; n < n3; ++n) {
            d += dArray[n];
        }
        d /= (double)n3;
        for (n = 1; n < n2; ++n) {
            dArray2[n] = VarianceOfBlocks.calculate(dArray, n, d);
        }
    }

    private static double calculate(double[] dArray, int n, double d) {
        int n2 = dArray.length;
        double d2 = (int)Math.floor(n2 / n);
        int n3 = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n4 = 0;
        while ((double)n4 < d2) {
            double d5 = 0.0;
            for (int i = 0; i < n; ++i) {
                d5 += dArray[n3];
                ++n3;
            }
            d3 = (d5 /= (double)n) - d;
            d4 += d3 * d3;
            ++n4;
        }
        return d4 /= d2;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length >= 1) {
            int n = 900000;
            Multicolumn multicolumn = new Multicolumn(1, n);
            try {
                multicolumn.read(stringArray[0]);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
            n = multicolumn.nRows();
            double[] dArray = new double[(int)((double)n / 100.0) + 1];
            System.err.println("Number of data points: " + n);
            System.err.println("Number of variance points: " + dArray.length);
            VarianceOfBlocks.calculate(multicolumn.getColumn(0), dArray);
            for (int i = 1; i <= (int)((double)n / 100.0); ++i) {
                System.out.println(i + " " + dArray[i] / dArray[1] * (double)i);
            }
            if (stringArray.length == 2) {
                System.out.println("Saving PDB file to: " + stringArray[1]);
            }
        }
    }
}

