/*
 * Decompiled with CFR 0.152.
 */
package jbcl.statistics;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import jbcl.calc.functions.MultidimensionalFunction;
import jbcl.statistics.MultidimensionalKDE;
import jbcl.statistics.RandGenerator;
import jbcl.statistics.kernels.MultiTriangleKernel;
import jbcl.util.Format;

public class TwoDimKDE
extends MultidimensionalKDE {
    protected double[][] m_hist;
    private static double[] tmp_vect;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TwoDimKDE(int[] nArray, double[] dArray, double[] dArray2, double d, MultidimensionalFunction multidimensionalFunction) {
        super(nArray, dArray, dArray2, d, multidimensionalFunction);
        if (!$assertionsDisabled && this.n_dim != 2) {
            throw new AssertionError();
        }
        this.m_hist = new double[this.m_nbins[0]][this.m_nbins[1]];
    }

    public double evaluate(double[] dArray) {
        int n;
        for (n = 0; n < this.n_dim; ++n) {
            if (dArray[n] < this.m_min[n]) {
                return -1.0;
            }
            if (!(dArray[n] > this.m_max[n])) continue;
            return -1.0;
        }
        n = this.findBin(dArray[0], 0);
        int n2 = this.findBin(dArray[1], 1);
        return this.m_hist[n][n2];
    }

    public void insert(double[] dArray) {
        int n = this.findBin(dArray[0], 0);
        int n2 = this.findBin(dArray[1], 1);
        if (n < 0) {
            this.m_underflow += 1.0;
            return;
        }
        if (n >= this.m_nbins[0]) {
            this.m_overflow += 1.0;
            return;
        }
        if (n2 < 0) {
            this.m_underflow += 1.0;
            return;
        }
        if (n2 >= this.m_nbins[1]) {
            this.m_overflow += 1.0;
            return;
        }
        int n3 = (int)(this.h / this.bin_width[0] * 3.0);
        int n4 = (int)(this.h / this.bin_width[1] * 3.0);
        int n5 = n - n3;
        int n6 = n2 - n3;
        int n7 = n + n3;
        int n8 = n2 + n3;
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n7 >= this.m_nbins[0]) {
            n7 = this.m_nbins[0] - 1;
        }
        if (n8 >= this.m_nbins[1]) {
            n8 = this.m_nbins[1] - 1;
        }
        for (int i = n5; i <= n7; ++i) {
            TwoDimKDE.tmp_vect[0] = (this.m_min[0] + (double)i * this.bin_width[0] - dArray[0]) / this.h;
            int n9 = n6;
            while (n9 <= n8) {
                TwoDimKDE.tmp_vect[1] = (this.m_min[1] + (double)n9 * this.bin_width[1] - dArray[1]) / this.h;
                double[] dArray2 = this.m_hist[i];
                int n10 = n9++;
                dArray2[n10] = dArray2[n10] + this.kernel_func.evaluate(tmp_vect);
            }
        }
        ++this.m_entries;
    }

    public void normalize() {
        int n;
        int n2;
        double d = 0.0;
        for (n2 = 0; n2 < this.m_nbins[0]; ++n2) {
            for (n = 0; n < this.m_nbins[1]; ++n) {
                d += this.m_hist[n2][n];
            }
        }
        d *= this.bin_width[1] * this.bin_width[0];
        for (n2 = 0; n2 < this.m_nbins[0]; ++n2) {
            n = 0;
            while (n < this.m_nbins[1]) {
                double[] dArray = this.m_hist[n2];
                int n3 = n++;
                dArray[n3] = dArray[n3] / d;
            }
        }
    }

    public void write(String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
            for (int i = 0; i < this.m_nbins[0]; ++i) {
                TwoDimKDE.tmp_vect[0] = this.m_min[0] + (double)i * this.bin_width[0];
                for (int j = 0; j < this.m_nbins[1]; ++j) {
                    TwoDimKDE.tmp_vect[1] = this.m_min[1] + (double)j * this.bin_width[1];
                    printWriter.println(Format.format(tmp_vect[0], 3, 4) + " " + Format.format(tmp_vect[1], 3, 4) + " " + Format.format(this.m_hist[i][j], 4, 5));
                }
            }
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File not found: " + string);
            System.exit(0);
        }
    }

    public void show() {
        for (int i = 0; i < this.m_nbins[0]; ++i) {
            TwoDimKDE.tmp_vect[0] = this.m_min[0] + (double)i * this.bin_width[0];
            for (int j = 0; j < this.m_nbins[1]; ++j) {
                TwoDimKDE.tmp_vect[1] = this.m_min[1] + (double)j * this.bin_width[1];
                System.out.println(Format.format(tmp_vect[0], 3, 4) + " " + Format.format(tmp_vect[1], 3, 4) + " " + Format.format(this.m_hist[i][j], 4, 5));
            }
        }
    }

    public static void main(String[] stringArray) {
        int[] nArray = new int[2];
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        dArray[1] = -5.0;
        dArray[0] = -5.0;
        dArray2[1] = 5.0;
        dArray2[0] = 5.0;
        nArray[1] = 100;
        nArray[0] = 100;
        TwoDimKDE twoDimKDE = new TwoDimKDE(nArray, dArray, dArray2, 0.5, (MultidimensionalFunction)new MultiTriangleKernel());
        for (int i = 0; i < 10000; ++i) {
            dArray3[0] = RandGenerator.randNormal();
            dArray3[1] = RandGenerator.randNormal();
            twoDimKDE.insert(dArray3);
        }
        twoDimKDE.write("test_result.dat");
    }

    static {
        $assertionsDisabled = !TwoDimKDE.class.desiredAssertionStatus();
        tmp_vect = new double[2];
    }
}

