/*
 * Decompiled with CFR 0.152.
 */
package jbcl.statistics;

import java.util.Random;
import jbcl.statistics.Histogram;
import jbcl.statistics.SimpleStatistics;

public class RandGenerator {
    private static Random rand = new Random();

    public static void seed(long l) {
        rand.setSeed(l);
    }

    public static double randNormal() {
        return rand.nextGaussian();
    }

    public static void randNormal(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = rand.nextGaussian();
        }
    }

    public static double randUniform() {
        return rand.nextDouble();
    }

    public static double randUniform(double d, double d2) {
        return rand.nextDouble() * (d2 - d) + d;
    }

    public static int randUniform(int n, int n2) {
        return rand.nextInt(n2 - n) + n;
    }

    public static void randUniform(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = rand.nextDouble();
        }
    }

    public static void resample(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[rand.nextInt(n)];
        }
    }

    public static void main(String[] stringArray) {
        int n;
        System.out.println("# Running a test for a RandGenerator:");
        System.out.println("# getting 100 random values:");
        System.out.println("# uniform      normal");
        for (int i = 0; i < 100; ++i) {
            System.out.println(RandGenerator.randUniform() + " " + RandGenerator.randNormal());
        }
        System.out.println("# Testing resample() method:");
        System.out.println("# Base observations:");
        double[] dArray = new double[]{1.54, 2.01, 1.99, 1.84, 1.6, 2.08, 1.76, 1.91};
        System.out.println("# Mean: " + SimpleStatistics.average(dArray));
        for (int i = 0; i < dArray.length; ++i) {
            System.out.print(dArray[i] + " ");
        }
        System.out.println("\n# Ten samples:");
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < 10; ++i) {
            RandGenerator.resample(dArray, dArray2);
            for (n = 0; n < dArray2.length; ++n) {
                System.out.print(dArray2[n] + " ");
            }
            System.out.println("");
        }
        Histogram histogram = new Histogram(50, 1.5, 2.1);
        for (n = 0; n < 10000; ++n) {
            RandGenerator.resample(dArray, dArray2);
            histogram.insert(SimpleStatistics.average(dArray2));
        }
        System.out.println("\n# Bootstrap distribution of a mean value for the sample:");
        histogram.show();
    }

    private RandGenerator() {
    }
}

