/*
 * Decompiled with CFR 0.152.
 */
package jbcl.statistics;

import jbcl.statistics.RandGenerator;

public class OrnsteinUhlenbeckProcess {
    private double mean = 0.0;
    private double sdev = 1.0;
    private double coupling_old = 0.5;
    private double coupling_new = 0.5;
    private double last_observation = 0.0;

    public OrnsteinUhlenbeckProcess(double d, double d2, double d3) {
        this.mean = d;
        this.sdev = d2;
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        if (d3 > 1.0) {
            d3 = 1.0;
        }
        this.coupling_old = d3;
        this.coupling_new = Math.sqrt(1.0 - d3 * d3);
    }

    public double nextObservation() {
        double d = RandGenerator.randNormal() * this.sdev + this.mean;
        this.last_observation = this.coupling_old * this.last_observation + this.coupling_new * d;
        return this.last_observation;
    }

    public static void main(String[] stringArray) {
        OrnsteinUhlenbeckProcess ornsteinUhlenbeckProcess = new OrnsteinUhlenbeckProcess(0.0, 1.0, 0.7);
        System.out.println("# Running a test for a OrnsteinUhlenbeckProcess:");
        System.out.println("# getting 100 observations:");
        for (int i = 0; i < 100; ++i) {
            System.out.println(ornsteinUhlenbeckProcess.nextObservation());
        }
    }
}

