/*
 * Decompiled with CFR 0.152.
 */
package jbcl.statistics;

import jbcl.calc.functions.MultidimensionalFunction;

public abstract class MultidimensionalKDE
implements MultidimensionalFunction {
    protected double[] m_min;
    protected double[] m_max;
    protected int[] m_nbins;
    protected int m_entries;
    protected double m_overflow;
    protected double m_underflow;
    protected int n_dim;
    protected double[] bin_width;
    protected double h = 1.0;
    protected MultidimensionalFunction kernel_func;

    public MultidimensionalKDE(int[] nArray, double[] dArray, double[] dArray2, double d, MultidimensionalFunction multidimensionalFunction) {
        this.kernel_func = multidimensionalFunction;
        this.h = d;
        this.n_dim = nArray.length;
        int n = 1;
        this.m_nbins = new int[this.n_dim];
        this.m_min = new double[this.n_dim];
        this.m_max = new double[this.n_dim];
        this.bin_width = new double[this.n_dim];
        for (int i = 0; i < this.n_dim; ++i) {
            this.m_nbins[i] = nArray[i];
            n *= nArray[i];
            this.m_min[i] = dArray[i];
            this.m_max[i] = dArray2[i];
            this.m_underflow = 0.0;
            this.m_overflow = 0.0;
            this.bin_width[i] = (this.m_max[i] - this.m_min[i]) / (double)this.m_nbins[i];
        }
    }

    public MultidimensionalKDE(int[] nArray, double[] dArray, double d, double d2, MultidimensionalFunction multidimensionalFunction) {
        this.kernel_func = multidimensionalFunction;
        this.h = d2;
        this.n_dim = nArray.length;
        int n = 1;
        this.m_nbins = new int[this.n_dim];
        this.m_min = new double[this.n_dim];
        this.m_max = new double[this.n_dim];
        this.bin_width = new double[this.n_dim];
        for (int i = 0; i < this.n_dim; ++i) {
            this.m_nbins[i] = nArray[i];
            n *= nArray[i];
            this.m_min[i] = dArray[i];
            this.m_max[i] = dArray[i] + (double)nArray[i] * d;
            this.m_underflow = 0.0;
            this.m_overflow = 0.0;
            this.bin_width[i] = d;
        }
    }

    public abstract double evaluate(double[] var1);

    public abstract void insert(double[] var1);

    public void insert(double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            this.insert(dArray[i]);
        }
    }

    public abstract void write(String var1);

    public abstract void show();

    public int entries() {
        return this.m_entries;
    }

    public int numberOfBins(int n) {
        return this.m_nbins[n];
    }

    public double min(int n) {
        return this.m_min[n];
    }

    public double max(int n) {
        return this.m_max[n];
    }

    public double overflow() {
        return this.m_overflow;
    }

    public double underflow() {
        return this.m_underflow;
    }

    public abstract void normalize();

    protected int findBin(double d, int n) {
        return (int)((d - this.m_min[n]) / this.bin_width[n]);
    }
}

