/*
 * Decompiled with CFR 0.152.
 */
package jbcl.statistics;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import jbcl.calc.functions.Function;
import jbcl.statistics.Histogram;
import jbcl.statistics.RandGenerator;
import jbcl.statistics.kernels.TriangleKernel;

public class KDE
extends Histogram
implements Function {
    protected double h = 1.0;
    protected Function kernel_func;

    public KDE(int n, double d, double d2, double d3, Function function) {
        super(n, d, d2);
        this.kernel_func = function;
        this.h = d3;
    }

    public double evaluate(double d) {
        if (d < this.m_min) {
            return 0.0;
        }
        if (d > this.m_max) {
            return 0.0;
        }
        int n = this.findBin(d);
        return this.m_hist[n] / ((double)this.m_entries * this.h);
    }

    public void insert(double d) {
        if (d < this.m_min) {
            this.m_underflow += 1.0;
            return;
        }
        if (d > this.m_max) {
            this.m_overflow += 1.0;
            return;
        }
        for (int i = 0; i < this.m_nbins; ++i) {
            int n = i;
            this.m_hist[n] = this.m_hist[n] + this.kernel_func.evaluate((this.m_min + (double)i * this.bin_width - d) / this.h);
        }
        ++this.m_entries;
    }

    public void insert(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            this.insert(dArray[i]);
        }
    }

    public double mean() {
        double d = 0.0;
        for (int i = 0; i < this.m_nbins; ++i) {
            d += this.m_hist[i] * (this.m_min + (double)i * this.bin_width) * this.bin_width;
        }
        return d / ((double)this.m_entries * this.h);
    }

    public void write(String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
            for (int i = 0; i < this.m_nbins; ++i) {
                double d = this.m_min + this.bin_width * (double)i;
                printWriter.println(d + " " + this.evaluate(d));
            }
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File not found: " + string);
            System.exit(0);
        }
    }

    public void show() {
        System.out.println("# x        pdf(x)");
        for (int i = 0; i < this.m_nbins; ++i) {
            System.out.println(this.m_min + (double)i * this.bin_width + "   " + this.m_hist[i] / ((double)this.m_entries * this.h));
        }
    }

    public static void main(String[] stringArray) {
        int n = 10000;
        System.out.println("# Running a test for a KDE class:");
        System.out.println("# Getting " + n + " random variables from N(0.0,1.0)");
        double[] dArray = new double[n];
        RandGenerator.randNormal(dArray);
        KDE kDE = new KDE(1000, -5.0, 5.0, 0.5, new TriangleKernel());
        kDE.insert(dArray);
        kDE.show();
    }
}

