/*
 * Decompiled with CFR 0.152.
 */
package jbcl.statistics;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import jbcl.statistics.RandGenerator;

public class Histogram2D {
    protected double[][] m_hist;
    protected double m_min_i;
    protected double m_max_i;
    protected double m_min_j;
    protected double m_max_j;
    protected int m_nbins_i;
    protected int m_nbins_j;
    protected int m_nbins;
    protected int m_entries;
    protected double m_overflow;
    protected double m_underflow;
    protected double bin_width_i;
    protected double bin_width_j;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Histogram2D() {
    }

    public Histogram2D(int n, double d, double d2, int n2, double d3, double d4) {
        this.m_nbins_i = n;
        this.m_min_i = d;
        this.m_max_i = d2;
        this.m_underflow = 0.0;
        this.m_overflow = 0.0;
        this.bin_width_i = (this.m_max_i - this.m_min_i) / (double)this.m_nbins_i;
        this.m_nbins_j = n2;
        this.m_min_j = d3;
        this.m_max_j = d4;
        this.m_underflow = 0.0;
        this.m_overflow = 0.0;
        this.bin_width_j = (this.m_max_j - this.m_min_j) / (double)this.m_nbins_j;
        this.m_hist = new double[this.m_nbins_i][this.m_nbins_j];
    }

    public Histogram2D(double[] dArray, double[] dArray2, int n, int n2) {
        int n3;
        int n4 = dArray.length;
        if (!$assertionsDisabled && dArray.length != dArray2.length) {
            throw new AssertionError();
        }
        this.m_min_i = this.m_max_i = dArray[0];
        this.m_min_j = this.m_max_j = dArray2[0];
        this.m_entries = 0;
        for (n3 = 1; n3 < n4; ++n3) {
            if (this.m_min_i > dArray[n3]) {
                this.m_min_i = dArray[n3];
            }
            if (this.m_max_i < dArray[n3]) {
                this.m_max_i = dArray[n3];
            }
            if (this.m_min_j > dArray2[n3]) {
                this.m_min_j = dArray2[n3];
            }
            if (!(this.m_max_j < dArray2[n3])) continue;
            this.m_max_j = dArray2[n3];
        }
        this.m_nbins_i = n;
        this.m_nbins_j = n2;
        this.m_hist = new double[this.m_nbins_i][this.m_nbins_j];
        this.m_underflow = 0.0;
        this.m_overflow = 0.0;
        this.bin_width_i = (this.m_max_i - this.m_min_i) / (double)this.m_nbins_i;
        this.bin_width_j = (this.m_max_j - this.m_min_j) / (double)this.m_nbins_j;
        for (n3 = 0; n3 < n4; ++n3) {
            this.insert(dArray[n3], dArray2[n3]);
        }
    }

    public double checkBin(double d, double d2) {
        if (d < this.m_min_i) {
            return -1.0;
        }
        if (d > this.m_max_i) {
            return -1.0;
        }
        if (d2 < this.m_min_j) {
            return -1.0;
        }
        if (d2 > this.m_max_j) {
            return -1.0;
        }
        int n = (int)((d - this.m_min_i) / this.bin_width_i);
        int n2 = (int)((d2 - this.m_min_j) / this.bin_width_j);
        return this.m_hist[n][n2];
    }

    public double checkBin(int n, int n2) {
        return this.m_hist[n][n2];
    }

    public void insert(double d, double d2) {
        if (d < this.m_min_i) {
            this.m_underflow += 1.0;
            return;
        }
        if (d > this.m_max_i) {
            this.m_overflow += 1.0;
            return;
        }
        if (d2 < this.m_min_j) {
            this.m_underflow += 1.0;
            return;
        }
        if (d2 > this.m_max_j) {
            this.m_overflow += 1.0;
            return;
        }
        try {
            int n = (int)((d - this.m_min_i) / this.bin_width_i);
            int n2 = (int)((d2 - this.m_min_j) / this.bin_width_j);
            double[] dArray = this.m_hist[n];
            int n3 = n2;
            dArray[n3] = dArray[n3] + 1.0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("jbcl.statistics.Histogram.insert():Incorrect bin number = " + arrayIndexOutOfBoundsException.getMessage());
            System.err.println("jbcl.statistics.Histogram.insert():Input data: " + d + " " + d2);
        }
        ++this.m_entries;
    }

    public void insert(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        if (!$assertionsDisabled && dArray.length != dArray2.length) {
            throw new AssertionError();
        }
        for (int i = 0; i < n; ++i) {
            this.insert(dArray[i], dArray2[i]);
        }
    }

    public void normalize() {
        double d = this.area();
        for (int i = 0; i < this.m_nbins_i; ++i) {
            int n = 0;
            while (n < this.m_nbins_j) {
                double[] dArray = this.m_hist[i];
                int n2 = n++;
                dArray[n2] = dArray[n2] / d;
            }
        }
    }

    public double area() {
        double d = 0.0;
        for (int i = 0; i < this.m_nbins_i; ++i) {
            for (int j = 0; j < this.m_nbins_j; ++j) {
                d += this.m_hist[i][j];
            }
        }
        return d * this.bin_width_i * this.bin_width_j;
    }

    public void write(String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
            for (int i = 0; i < this.m_nbins_i; ++i) {
                for (int j = 0; j < this.m_nbins_j; ++j) {
                    printWriter.println(this.m_min_i + this.bin_width_i * (double)i + " " + (this.m_min_j + this.bin_width_j * (double)j) + " " + this.m_hist[i][j]);
                }
            }
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File not found: " + string);
            System.exit(0);
        }
    }

    public void write() {
        for (int i = 0; i < this.m_nbins_i; ++i) {
            for (int j = 0; j < this.m_nbins_j; ++j) {
                System.out.println(this.m_min_i + this.bin_width_i * (double)i + " " + (this.m_min_j + this.bin_width_j * (double)j) + " " + this.m_hist[i][j]);
            }
        }
    }

    public int entries() {
        return this.m_entries;
    }

    public double overflow() {
        return this.m_overflow;
    }

    public double underflow() {
        return this.m_underflow;
    }

    public double[][] getArray() {
        return this.m_hist;
    }

    public void clear() {
        for (int i = 0; i < this.m_nbins_i; ++i) {
            for (int j = 0; j < this.m_nbins_j; ++j) {
                this.m_hist[i][j] = 0.0;
            }
        }
        this.m_underflow = 0.0;
        this.m_overflow = 0.0;
        this.m_entries = 0;
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[100000];
        double[] dArray2 = new double[100000];
        RandGenerator.randNormal(dArray);
        RandGenerator.randNormal(dArray2);
        Histogram2D histogram2D = new Histogram2D(20, -10.0, 10.0, 20, -10.0, 10.0);
        histogram2D.insert(dArray, dArray2);
        histogram2D.write();
    }

    static {
        $assertionsDisabled = !Histogram2D.class.desiredAssertionStatus();
    }
}

