/*
 * Decompiled with CFR 0.152.
 */
package jbcl.statistics;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class Histogram {
    protected double[] m_hist;
    protected double m_min;
    protected double m_max;
    protected int m_nbins;
    protected int m_entries;
    protected double m_overflow;
    protected double m_underflow;
    protected boolean m_debug;
    protected double bin_width;

    public Histogram() {
    }

    public Histogram(int n, double d, double d2) {
        this.m_nbins = n;
        this.m_min = d;
        this.m_max = d2;
        this.m_hist = new double[this.m_nbins];
        this.m_underflow = 0.0;
        this.m_overflow = 0.0;
        this.bin_width = (this.m_max - this.m_min) / (double)this.m_nbins;
    }

    public Histogram(double[] dArray, int n) {
        int n2;
        int n3 = dArray.length;
        this.m_min = this.m_max = dArray[0];
        this.m_entries = 0;
        for (n2 = 1; n2 < n3; ++n2) {
            if (this.m_min > dArray[n2]) {
                this.m_min = dArray[n2];
            }
            if (!(this.m_max < dArray[n2])) continue;
            this.m_max = dArray[n2];
        }
        this.m_nbins = n;
        this.m_hist = new double[this.m_nbins];
        this.m_underflow = 0.0;
        this.m_overflow = 0.0;
        this.bin_width = (this.m_max - this.m_min) / (double)this.m_nbins;
        for (n2 = 0; n2 < n3; ++n2) {
            this.insert(dArray[n2]);
        }
    }

    public double checkBin(double d) {
        if (d < this.m_min) {
            return -1.0;
        }
        if (d > this.m_max) {
            return -1.0;
        }
        return this.m_hist[this.findBin(d)];
    }

    public double checkBin(int n) {
        return this.m_hist[n];
    }

    public void insert(double d) {
        if (d < this.m_min) {
            this.m_underflow += 1.0;
            return;
        }
        if (d > this.m_max) {
            this.m_overflow += 1.0;
            return;
        }
        try {
            int n = this.findBin(d);
            this.m_hist[n] = this.m_hist[n] + 1.0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("jbcl.statistics.Histogram.insert():Incorrect bin number = " + arrayIndexOutOfBoundsException.getMessage());
        }
        ++this.m_entries;
    }

    public void insert(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            this.insert(dArray[i]);
        }
    }

    public void normalize() {
        double d = this.area();
        int n = 0;
        while (n < this.m_nbins) {
            int n2 = n++;
            this.m_hist[n2] = this.m_hist[n2] / d;
        }
    }

    public double mean() {
        double d = 0.0;
        for (int i = 0; i < this.m_nbins; ++i) {
            double d2 = this.m_min + ((double)i + 0.5) * this.bin_width;
            d += this.m_hist[i] * d2;
        }
        return d / ((double)this.m_entries - this.m_overflow - this.m_underflow);
    }

    public double area() {
        double d = 0.0;
        for (int i = 0; i < this.m_nbins; ++i) {
            d += this.m_hist[i];
        }
        return d * this.bin_width;
    }

    public void write(String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
            for (int i = 0; i < this.m_nbins; ++i) {
                printWriter.println(this.m_min + this.bin_width * (double)i + " " + this.m_hist[i]);
            }
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File not found: " + string);
            System.exit(0);
        }
    }

    public void show() {
        System.out.println("# bin range        height");
        for (int i = 0; i < this.m_nbins; ++i) {
            double d = this.m_min + (double)i * this.bin_width;
            double d2 = d + this.bin_width;
            System.out.println(d + " to " + d2 + "   " + this.m_hist[i]);
        }
    }

    public int entries() {
        return this.m_entries;
    }

    public int numberOfBins() {
        return this.m_nbins;
    }

    public double min() {
        return this.m_min;
    }

    public double max() {
        return this.m_max;
    }

    public double overflow() {
        return this.m_overflow;
    }

    public double underflow() {
        return this.m_underflow;
    }

    public double[] getArray() {
        return this.m_hist;
    }

    public void clear() {
        for (int i = 0; i < this.m_nbins; ++i) {
            this.m_hist[i] = 0.0;
        }
        this.m_underflow = 0.0;
        this.m_overflow = 0.0;
        this.m_entries = 0;
    }

    protected int findBin(double d) {
        return (int)((d - this.m_min) / this.bin_width);
    }
}

