/*
 * Decompiled with CFR 0.152.
 */
package jbcl.statistics;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import jbcl.calc.functions.MultidimensionalFunction;
import jbcl.statistics.MultidimensionalKDE;
import jbcl.util.Format;

public class FourDimKDE
extends MultidimensionalKDE {
    protected double[][][][] m_hist;
    private static double[] tmp_vect;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FourDimKDE(int[] nArray, double[] dArray, double[] dArray2, double d, MultidimensionalFunction multidimensionalFunction) {
        super(nArray, dArray, dArray2, d, multidimensionalFunction);
        if (!$assertionsDisabled && this.n_dim != 4) {
            throw new AssertionError();
        }
        this.m_hist = new double[this.m_nbins[0]][this.m_nbins[1]][this.m_nbins[2]][this.m_nbins[3]];
    }

    public FourDimKDE(int[] nArray, double[] dArray, double d, double d2, MultidimensionalFunction multidimensionalFunction) {
        super(nArray, dArray, d, d2, multidimensionalFunction);
        if (!$assertionsDisabled && this.n_dim != 4) {
            throw new AssertionError();
        }
        this.m_hist = new double[this.m_nbins[0]][this.m_nbins[1]][this.m_nbins[2]][this.m_nbins[3]];
    }

    public double evaluate(double[] dArray) {
        int n;
        for (n = 0; n < this.n_dim; ++n) {
            if (dArray[n] < this.m_min[n]) {
                return -1.0;
            }
            if (!(dArray[n] > this.m_max[n])) continue;
            return -1.0;
        }
        n = this.findBin(dArray[0], 0);
        int n2 = this.findBin(dArray[1], 1);
        int n3 = this.findBin(dArray[2], 2);
        int n4 = this.findBin(dArray[3], 3);
        return this.m_hist[n][n2][n3][n4];
    }

    public void insert(double[] dArray) {
        int n = this.findBin(dArray[0], 0);
        int n2 = this.findBin(dArray[1], 1);
        int n3 = this.findBin(dArray[2], 2);
        int n4 = this.findBin(dArray[3], 3);
        if (n < 0) {
            this.m_underflow += 1.0;
            return;
        }
        if (n >= this.m_nbins[0]) {
            this.m_overflow += 1.0;
            return;
        }
        if (n2 < 0) {
            this.m_underflow += 1.0;
            return;
        }
        if (n2 >= this.m_nbins[1]) {
            this.m_overflow += 1.0;
            return;
        }
        if (n3 < 0) {
            this.m_underflow += 1.0;
            return;
        }
        if (n3 >= this.m_nbins[2]) {
            this.m_overflow += 1.0;
            return;
        }
        if (n4 < 0) {
            this.m_underflow += 1.0;
            return;
        }
        if (n4 >= this.m_nbins[3]) {
            this.m_overflow += 1.0;
            return;
        }
        int n5 = (int)(this.h / this.bin_width[0] * 3.0);
        int n6 = (int)(this.h / this.bin_width[1] * 3.0);
        int n7 = (int)(this.h / this.bin_width[2] * 3.0);
        int n8 = (int)(this.h / this.bin_width[3] * 3.0);
        int n9 = n - n5;
        int n10 = n2 - n6;
        int n11 = n + n5;
        int n12 = n2 + n6;
        int n13 = n3 - n7;
        int n14 = n4 - n8;
        int n15 = n3 + n7;
        int n16 = n4 + n8;
        if (n9 < 0) {
            n9 = 0;
        }
        if (n10 < 0) {
            n10 = 0;
        }
        if (n11 >= this.m_nbins[0]) {
            n11 = this.m_nbins[0] - 1;
        }
        if (n12 >= this.m_nbins[1]) {
            n12 = this.m_nbins[1] - 1;
        }
        if (n13 < 0) {
            n13 = 0;
        }
        if (n14 < 0) {
            n14 = 0;
        }
        if (n15 >= this.m_nbins[2]) {
            n15 = this.m_nbins[2] - 1;
        }
        if (n16 >= this.m_nbins[3]) {
            n16 = this.m_nbins[3] - 1;
        }
        for (int i = n9; i <= n11; ++i) {
            FourDimKDE.tmp_vect[0] = (this.m_min[0] + (double)i * this.bin_width[0] - dArray[0]) / this.h;
            for (int j = n10; j <= n12; ++j) {
                FourDimKDE.tmp_vect[1] = (this.m_min[1] + (double)j * this.bin_width[1] - dArray[1]) / this.h;
                for (int k = n13; k <= n15; ++k) {
                    FourDimKDE.tmp_vect[2] = (this.m_min[2] + (double)k * this.bin_width[2] - dArray[2]) / this.h;
                    int n17 = n14;
                    while (n17 <= n16) {
                        FourDimKDE.tmp_vect[3] = (this.m_min[3] + (double)n17 * this.bin_width[3] - dArray[3]) / this.h;
                        double[] dArray2 = this.m_hist[i][j][k];
                        int n18 = n17++;
                        dArray2[n18] = dArray2[n18] + this.kernel_func.evaluate(tmp_vect);
                    }
                }
            }
        }
        ++this.m_entries;
    }

    public void normalize() {
        int n;
        int n2;
        int n3;
        int n4;
        double d = 0.0;
        for (n4 = 0; n4 < this.m_nbins[0]; ++n4) {
            for (n3 = 0; n3 < this.m_nbins[1]; ++n3) {
                for (n2 = 0; n2 < this.m_nbins[2]; ++n2) {
                    for (n = 0; n < this.m_nbins[3]; ++n) {
                        d += this.m_hist[n4][n3][n2][n];
                    }
                }
            }
        }
        d *= this.bin_width[1] * this.bin_width[0] * this.bin_width[2] * this.bin_width[3];
        for (n4 = 0; n4 < this.m_nbins[0]; ++n4) {
            for (n3 = 0; n3 < this.m_nbins[1]; ++n3) {
                for (n2 = 0; n2 < this.m_nbins[2]; ++n2) {
                    n = 0;
                    while (n < this.m_nbins[3]) {
                        double[] dArray = this.m_hist[n4][n3][n2];
                        int n5 = n++;
                        dArray[n5] = dArray[n5] / d;
                    }
                }
            }
        }
    }

    public void write(String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
            for (int i = 0; i < this.m_nbins[0]; ++i) {
                FourDimKDE.tmp_vect[0] = this.m_min[0] + (double)i * this.bin_width[0];
                for (int j = 0; j < this.m_nbins[1]; ++j) {
                    FourDimKDE.tmp_vect[1] = this.m_min[1] + (double)j * this.bin_width[1];
                    for (int k = 0; k < this.m_nbins[2]; ++k) {
                        FourDimKDE.tmp_vect[2] = this.m_min[2] + (double)k * this.bin_width[2];
                        for (int i2 = 0; i2 < this.m_nbins[3]; ++i2) {
                            FourDimKDE.tmp_vect[3] = this.m_min[3] + (double)i2 * this.bin_width[3];
                            printWriter.println(Format.format(tmp_vect[0], 3, 4) + " " + Format.format(tmp_vect[1], 3, 4) + " " + Format.format(tmp_vect[2], 3, 4) + " " + Format.format(tmp_vect[3], 3, 4) + " " + Format.format(this.m_hist[i][j][k][i2], 4, 5));
                        }
                    }
                }
            }
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File not found: " + string);
            System.exit(0);
        }
    }

    public void show() {
        for (int i = 0; i < this.m_nbins[0]; ++i) {
            FourDimKDE.tmp_vect[0] = this.m_min[0] + (double)i * this.bin_width[0];
            for (int j = 0; j < this.m_nbins[1]; ++j) {
                FourDimKDE.tmp_vect[1] = this.m_min[1] + (double)j * this.bin_width[1];
                for (int k = 0; k < this.m_nbins[2]; ++k) {
                    FourDimKDE.tmp_vect[2] = this.m_min[2] + (double)k * this.bin_width[2];
                    for (int i2 = 0; i2 < this.m_nbins[3]; ++i2) {
                        FourDimKDE.tmp_vect[3] = this.m_min[3] + (double)i2 * this.bin_width[3];
                        System.out.println(Format.format(tmp_vect[0], 3, 4) + " " + Format.format(tmp_vect[1], 3, 4) + " " + Format.format(tmp_vect[2], 3, 4) + " " + Format.format(tmp_vect[3], 3, 4) + " " + Format.format(this.m_hist[i][j][k][i2], 4, 5));
                    }
                }
            }
        }
    }

    static {
        $assertionsDisabled = !FourDimKDE.class.desiredAssertionStatus();
        tmp_vect = new double[4];
    }
}

