/*
 * Decompiled with CFR 0.152.
 */
package jbcl.simulations.interactions;

import jbcl.datatypes.Vector3D;
import jbcl.simulations.interactions.VanderWaals12_10;

public class VdW12_10WithHarmonic
extends VanderWaals12_10 {
    public double last_energy;
    public double last_VdW_energy;
    public double last_harmonic_energy;
    public double last_distance;
    private double d0 = 0.0;
    private double force = 0.0;

    public VdW12_10WithHarmonic(Vector3D vector3D, Vector3D vector3D2, double d, double d2, double d3) {
        super(vector3D, vector3D2, d);
        this.force = d3;
        this.d0 = d2;
    }

    public double calculateEnergy() {
        this.last_distance = this.body1.distance(this.body2);
        this.last_harmonic_energy = this.last_distance - this.d0;
        this.last_harmonic_energy *= this.last_harmonic_energy;
        this.last_harmonic_energy *= this.force;
        this.last_VdW_energy = super.calculateEnergy(this.last_distance);
        this.last_energy = this.last_VdW_energy + this.last_harmonic_energy;
        return this.last_energy;
    }

    public static void main(String[] stringArray) {
        Vector3D vector3D = new Vector3D(1.0);
        Vector3D vector3D2 = new Vector3D(2.0, 2.0, 2.3);
        Vector3D vector3D3 = new Vector3D(0.01);
        double d = vector3D.distance(vector3D2);
        double d2 = d / 3.0;
        VdW12_10WithHarmonic vdW12_10WithHarmonic = new VdW12_10WithHarmonic(vector3D, vector3D2, d2, d, 10.0);
        Vector3D vector3D4 = new Vector3D(1.0);
        vector3D.sub(vector3D4);
        for (int i = 0; i < 200; ++i) {
            vector3D.add(vector3D3);
            vdW12_10WithHarmonic.calculateEnergy();
            System.out.println(vdW12_10WithHarmonic.last_distance + " " + vdW12_10WithHarmonic.last_energy + " " + vdW12_10WithHarmonic.last_VdW_energy + " " + vdW12_10WithHarmonic.last_harmonic_energy);
        }
    }
}

