/*
 * Decompiled with CFR 0.152.
 */
package jbcl.simulations.interactions;

import jbcl.datatypes.Vector3D;
import jbcl.simulations.interactions.Interaction;

public class VanderWaals12_10
implements Interaction {
    public static double CUTOFF_FACTOR = 5.0;
    public double last_energy;
    public double last_distance;
    protected double distance = 0.0;
    protected Vector3D body1;
    protected Vector3D body2;
    protected static double CUTOFF = 0.0;

    public VanderWaals12_10(Vector3D vector3D, Vector3D vector3D2, double d) {
        this.body1 = vector3D;
        this.body2 = vector3D2;
        this.distance = d;
        CUTOFF = d * CUTOFF_FACTOR;
    }

    public double calculateEnergy() {
        this.last_distance = this.body1.distance(this.body2);
        if (CUTOFF > this.last_distance) {
            double d = this.distance / this.last_distance;
            double d2 = d * d;
            double d3 = d2 * d2;
            double d4 = d3 * d3;
            this.last_energy = 5.0 * d4 * d3 - 6.0 * d4 * d2;
        }
        return this.last_energy;
    }

    public double calculateEnergy(double d) {
        double d2 = 0.0;
        if (CUTOFF > d) {
            double d3 = this.distance / d;
            double d4 = d3 * d3;
            double d5 = d4 * d4;
            double d6 = d5 * d5;
            d2 = 5.0 * d6 * d5 - 6.0 * d6 * d4;
        }
        return d2;
    }

    public static void main(String[] stringArray) {
        Vector3D vector3D = new Vector3D(1.0);
        Vector3D vector3D2 = new Vector3D(2.0, 2.0, 2.3);
        Vector3D vector3D3 = new Vector3D(0.01);
        double d = vector3D.distance(vector3D2);
        double d2 = d / 3.0;
        VanderWaals12_10 vanderWaals12_10 = new VanderWaals12_10(vector3D, vector3D2, d2);
        Vector3D vector3D4 = new Vector3D(1.0);
        vector3D.sub(vector3D4);
        for (int i = 0; i < 200; ++i) {
            vector3D.add(vector3D3);
            vanderWaals12_10.calculateEnergy();
            System.out.println(vanderWaals12_10.last_distance + " " + vanderWaals12_10.last_energy);
        }
    }
}

