/*
 * Decompiled with CFR 0.152.
 */
package jbcl.simulations.interactions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import jbcl.datatypes.Vector3D;
import jbcl.simulations.interactions.Interaction;

public class HarmonicInteraction
implements Interaction {
    public double last_energy;
    public double last_distance;
    private double k = 0.0;
    private double d0 = 0.0;
    private Vector3D body1;
    private Vector3D body2;

    public HarmonicInteraction(Vector3D vector3D, Vector3D vector3D2, double d, double d2) {
        this.body1 = vector3D;
        this.body2 = vector3D2;
        this.k = d2 * 0.5;
        this.d0 = d;
    }

    public double calculateEnergy() {
        this.last_distance = this.body1.distance(this.body2);
        this.last_energy = this.last_distance - this.d0;
        this.last_energy *= this.last_energy;
        this.last_energy *= this.k;
        return this.last_energy;
    }

    public static double[][] readHarmonicSprings(String string) {
        Object object;
        String[] stringArray = new String[1000000];
        int n = 0;
        try {
            String string2;
            object = new BufferedReader(new FileReader(new File(string)));
            while ((string2 = ((BufferedReader)object).readLine()) != null) {
                if (string2.length() < 6 || string2.charAt(0) == '#') continue;
                stringArray[n] = string2;
                ++n;
            }
            ((BufferedReader)object).close();
        }
        catch (IOException iOException) {
            System.out.println("HarmonicInteraction::readHarmonicSprings(): Can't find file: " + string);
            System.exit(0);
        }
        object = new double[n][4];
        for (int i = 0; i < n; ++i) {
            String[] stringArray2 = stringArray[i].split("\\s+");
            Object object2 = object[i];
            object2[0] = (double)(Integer.parseInt(stringArray2[0].trim()) - 1);
            object2[1] = (double)(Integer.parseInt(stringArray2[1].trim()) - 1);
            object2[2] = Double.parseDouble(stringArray2[2].trim());
            object2[3] = Double.parseDouble(stringArray2[3].trim());
        }
        return object;
    }

    public static void main(String[] stringArray) {
        Vector3D vector3D = new Vector3D(1.0);
        Vector3D vector3D2 = new Vector3D(1.0, 2.0, 2.3);
        Vector3D vector3D3 = new Vector3D(0.01);
        double d = vector3D.distance(vector3D2);
        HarmonicInteraction harmonicInteraction = new HarmonicInteraction(vector3D, vector3D2, d, 1.2);
        for (int i = 0; i < 100; ++i) {
            vector3D2.add(vector3D3);
            harmonicInteraction.calculateEnergy();
            System.out.println(harmonicInteraction.last_distance + " " + harmonicInteraction.last_energy);
        }
    }
}

