/*
 * Decompiled with CFR 0.152.
 */
package jbcl.simulations.interactions;

import jbcl.datatypes.Vector3D;
import jbcl.simulations.interactions.Interaction;

public class ExcludedVolume
implements Interaction {
    public static double CUTOFF_FACTOR = 4.0;
    public double last_energy;
    public double last_distance;
    private double r_core1 = 0.0;
    private double r_core2 = 0.0;
    private Vector3D body1;
    private Vector3D body2;
    private static double CUTOFF_1 = 0.0;
    private static double CUTOFF_2 = 0.0;

    public ExcludedVolume(Vector3D vector3D, Vector3D vector3D2, double d, double d2) {
        this.body1 = vector3D;
        this.body2 = vector3D2;
        this.r_core1 = d;
        this.r_core2 = d2;
        CUTOFF_1 = this.r_core1 * CUTOFF_FACTOR;
        CUTOFF_2 = this.r_core2 * CUTOFF_FACTOR;
    }

    public double calculateEnergy() {
        double d;
        double d2;
        this.last_distance = this.body1.distance(this.body2);
        if (CUTOFF_1 > this.last_distance) {
            d2 = this.r_core1 / this.last_distance;
            d = d2 * d2;
            d2 = d * d;
            d = d2 * d2;
            this.last_energy = d * d2;
        }
        if (CUTOFF_2 > this.last_distance) {
            d2 = this.r_core2 / this.last_distance;
            d = d2 * d2;
            d2 = d * d;
            d = d2 * d2;
            this.last_energy += d * d2;
        }
        return this.last_energy;
    }

    public static void main(String[] stringArray) {
        Vector3D vector3D = new Vector3D(1.0);
        Vector3D vector3D2 = new Vector3D(2.0, 2.0, 2.3);
        Vector3D vector3D3 = new Vector3D(0.01);
        double d = vector3D.distance(vector3D2);
        double d2 = d / 3.0;
        ExcludedVolume excludedVolume = new ExcludedVolume(vector3D, vector3D2, d2, d2);
        Vector3D vector3D4 = new Vector3D(1.0);
        vector3D.sub(vector3D4);
        for (int i = 0; i < 200; ++i) {
            vector3D.add(vector3D3);
            excludedVolume.calculateEnergy();
            System.out.println(excludedVolume.last_distance + " " + excludedVolume.last_energy);
        }
    }
}

