/*
 * Decompiled with CFR 0.152.
 */
package jbcl.simulations;

import java.io.PrintWriter;
import jbcl.datatypes.Atom;
import jbcl.datatypes.TraFrame;
import jbcl.datatypes.Vector3D;
import jbcl.simulations.Model;
import jbcl.simulations.interactions.HarmonicInteraction;
import jbcl.simulations.interactions.Interaction;
import jbcl.statistics.RandGenerator;
import jbcl.util.Format;

public class TwoBodyInteractionsSet
extends Model {
    public int n_forces = 0;
    public int n_atoms = 0;
    public Atom[] atoms;
    public static double STEP_SIZE = 0.4;
    protected Interaction[] forces;
    protected Interaction[][] atom_forces;
    protected int[] n_atom_forces;
    protected int max_forces_for_atom = 0;
    protected int max_atoms = 0;
    protected int max_forces = 0;
    protected int n_snapshots = 0;

    public TwoBodyInteractionsSet(int n, int n2, int n3) {
        this.atoms = new Atom[n];
        this.forces = new Interaction[n2];
        this.atom_forces = new Interaction[n][n3];
        this.n_atom_forces = new int[n];
        this.max_forces_for_atom = n3;
        this.max_atoms = n;
        this.max_forces = n2;
        this.n_atoms = 0;
        this.n_forces = 0;
    }

    public void set(Model model) {
        int n;
        super.set(model);
        TwoBodyInteractionsSet twoBodyInteractionsSet = (TwoBodyInteractionsSet)model;
        if (this.atoms == null) {
            this.atoms = new Atom[twoBodyInteractionsSet.n_atoms];
            this.n_atoms = twoBodyInteractionsSet.n_atoms;
            for (n = 0; n < this.n_atoms; ++n) {
                this.atoms[n] = new Atom();
            }
        } else if (this.n_atoms != twoBodyInteractionsSet.n_atoms) {
            this.atoms = new Atom[twoBodyInteractionsSet.n_atoms];
            this.n_atoms = twoBodyInteractionsSet.n_atoms;
            for (n = 0; n < this.n_atoms; ++n) {
                this.atoms[n] = new Atom();
            }
        }
        for (n = 0; n < this.n_atoms; ++n) {
            this.atoms[n].set(twoBodyInteractionsSet.atoms[n]);
        }
    }

    public int addAtom(Atom atom) {
        this.atoms[this.n_atoms] = atom;
        ++this.n_atoms;
        return this.n_atoms - 1;
    }

    public int addAtoms(Atom[] atomArray) {
        for (int i = 0; i < atomArray.length; ++i) {
            if (this.n_atoms == this.max_atoms) {
                System.err.println("TwoBodyInteractionsSet::addAtoms: Too many atoms, can't insert " + atomArray[i]);
                System.exit(0);
            }
            this.atoms[this.n_atoms] = atomArray[i];
            ++this.n_atoms;
        }
        return this.n_atoms - 1;
    }

    public Interaction getForce(int n) {
        return this.forces[n];
    }

    public Atom getAtom(int n) {
        return this.atoms[n];
    }

    public int addForce(int n, int n2, Interaction interaction) {
        if (this.n_forces == this.max_forces) {
            System.err.println("TwoBodyInteractionsSet::addForce: The total number of forces (that is " + this.max_forces + ") in the system already reached.\nCannot insert " + n + " " + n2);
            System.exit(0);
        }
        if (this.n_atom_forces[n] == this.max_forces_for_atom) {
            System.err.println("TwoBodyInteractionsSet::addForce: Too many forces for the atom no. " + n);
            System.err.println("Number of forces allowed for this atom is: " + this.max_forces_for_atom + " now is " + this.n_atom_forces[n]);
            System.exit(0);
        }
        if (this.n_atom_forces[n2] == this.max_forces_for_atom) {
            System.err.println("TwoBodyInteractionsSet::addForce: Too many forces for the atom no. " + n2);
            System.err.println("Number of forces allowed for this atom is: " + this.max_forces_for_atom + " now is " + this.n_atom_forces[n2]);
            System.exit(0);
        }
        this.forces[this.n_forces] = interaction;
        this.atom_forces[n][this.n_atom_forces[n]] = interaction;
        int n3 = n;
        this.n_atom_forces[n3] = this.n_atom_forces[n3] + 1;
        this.atom_forces[n2][this.n_atom_forces[n2]] = interaction;
        int n4 = n2;
        this.n_atom_forces[n4] = this.n_atom_forces[n4] + 1;
        ++this.n_forces;
        return this.n_forces - 1;
    }

    public double totalEnergy() {
        this.last_energy = 0.0;
        for (int i = 0; i < this.n_forces; ++i) {
            this.last_energy += this.forces[i].calculateEnergy();
        }
        return this.last_energy;
    }

    public double center(double d, double d2, double d3) {
        int n;
        Vector3D vector3D = new Vector3D(d, d2, d3);
        for (n = 0; n < this.atoms.length; ++n) {
            vector3D.sub(this.atoms[n]);
        }
        vector3D.div(this.atoms.length);
        for (n = 0; n < this.atoms.length; ++n) {
            this.atoms[n].add(vector3D);
        }
        return vector3D.length();
    }

    public void snapshot(PrintWriter printWriter) {
        ++this.n_snapshots;
        TraFrame traFrame = new TraFrame();
        traFrame.createHeader();
        traFrame.n_atoms = this.n_atoms;
        traFrame.atoms = this.atoms;
        traFrame.header[0] = this.n_snapshots;
        traFrame.header[1] = this.n_atoms;
        traFrame.header[2] = this.last_energy;
        traFrame.header[3] = this.temperature;
        traFrame.toTraStream(printWriter);
    }

    public double mcSweep(double d) {
        Vector3D vector3D = new Vector3D();
        Vector3D vector3D2 = new Vector3D();
        double d2 = (double)this.atoms.length * d;
        double d3 = 0.0;
        int n = 0;
        while ((double)n < d2) {
            int n2;
            double d4 = this.last_energy;
            int n3 = RandGenerator.randUniform(0, this.atoms.length);
            vector3D.x = RandGenerator.randUniform(-STEP_SIZE, STEP_SIZE);
            vector3D.y = RandGenerator.randUniform(-STEP_SIZE, STEP_SIZE);
            vector3D.z = RandGenerator.randUniform(-STEP_SIZE, STEP_SIZE);
            vector3D2.set(this.atoms[n3]);
            double d5 = -this.atom_forces[n3][0].calculateEnergy();
            for (n2 = 1; n2 < this.n_atom_forces[n3]; ++n2) {
                d5 -= this.atom_forces[n3][n2].calculateEnergy();
            }
            this.atoms[n3].add(vector3D);
            for (n2 = 0; n2 < this.n_atom_forces[n3]; ++n2) {
                d5 += this.atom_forces[n3][n2].calculateEnergy();
            }
            if (d5 < 0.0) {
                d3 += 1.0;
                this.last_energy += d5;
            } else {
                double d6 = RandGenerator.randUniform();
                if (d6 < Math.exp(-d5 / this.temperature)) {
                    d3 += 1.0;
                    this.last_energy += d5;
                } else {
                    this.atoms[n3].set(vector3D2);
                }
            }
            ++n;
        }
        return d3 / d2;
    }

    public void showAtoms() {
        for (int i = 0; i < this.atoms.length; ++i) {
            Atom atom = this.atoms[i];
            System.out.println(Format.format(i, 4) + Format.format(atom.x, 4, 3) + " " + Format.format(atom.y, 4, 3) + " " + Format.format(atom.z, 4, 3));
        }
    }

    public void showForces() {
        for (int i = 0; i < this.n_forces; ++i) {
            Interaction interaction = this.forces[i];
            System.out.println("Force  " + Format.format(i, 5) + ": " + interaction);
        }
    }

    public static void main(String[] stringArray) {
        TwoBodyInteractionsSet twoBodyInteractionsSet = new TwoBodyInteractionsSet(4, 6, 3);
        Atom atom = new Atom(0, 0.0, 0.0, 0.0);
        Atom atom2 = new Atom(1, 1.0, 0.0, 0.0);
        twoBodyInteractionsSet.addAtom(atom);
        twoBodyInteractionsSet.addAtom(atom2);
        twoBodyInteractionsSet.addAtom(new Atom(2, 1.0, 1.0, 0.0));
        twoBodyInteractionsSet.addAtom(new Atom(3, 0.0, 1.0, 0.0));
        twoBodyInteractionsSet.addForce(0, 1, new HarmonicInteraction(atom, atom2, 1.0, 1.0));
        twoBodyInteractionsSet.addForce(0, 2, new HarmonicInteraction(atom, twoBodyInteractionsSet.getAtom(2), 1.4142135623730951, 1.0));
        twoBodyInteractionsSet.addForce(0, 3, new HarmonicInteraction(atom, twoBodyInteractionsSet.getAtom(3), 1.0, 1.0));
        twoBodyInteractionsSet.addForce(1, 2, new HarmonicInteraction(atom2, twoBodyInteractionsSet.getAtom(2), 1.0, 1.0));
        twoBodyInteractionsSet.addForce(1, 3, new HarmonicInteraction(atom2, twoBodyInteractionsSet.getAtom(3), 1.4142135623730951, 1.0));
        twoBodyInteractionsSet.addForce(2, 3, new HarmonicInteraction(twoBodyInteractionsSet.getAtom(2), twoBodyInteractionsSet.getAtom(3), 1.0, 1.0));
        System.out.println("Making a system with four springs placed in the corners");
        System.out.println("of a square, connected with 6 springs (all pairwise combinations)...");
        twoBodyInteractionsSet.totalEnergy();
        twoBodyInteractionsSet.showAtoms();
        twoBodyInteractionsSet.showForces();
        System.out.println("After a Monte Carlo sweep in the temperature = 1.0;");
        twoBodyInteractionsSet.temperature = 1.0;
        twoBodyInteractionsSet.mcSweep(1.0);
        twoBodyInteractionsSet.center(0.5, 0.5, 0.0);
        twoBodyInteractionsSet.showAtoms();
        twoBodyInteractionsSet.showForces();
        System.out.println("After 100 Monte Carlo sweeps in the temperature = 1.0;");
        twoBodyInteractionsSet.mcSweep(100.0);
        twoBodyInteractionsSet.center(0.5, 0.5, 0.0);
        twoBodyInteractionsSet.showAtoms();
        twoBodyInteractionsSet.showForces();
    }
}

