/*
 * Decompiled with CFR 0.152.
 */
package jbcl.simulations;

import jbcl.simulations.Model;
import jbcl.simulations.Observer;
import jbcl.statistics.RandGenerator;

public class ParallelTempering {
    public double lowest_energy;
    public double[] temperatures;
    public Model[] pt_system;
    public Model lowest_conformation;
    public int n_replicas;
    public int[] replica_swaps;
    public byte[] replica_flags;
    public Observer energy_stream = null;
    public Observer id_stream = null;
    public Observer lowest_en_stream = null;
    public Observer flags_stream = null;
    public Observer tra_stream = null;
    private double[] double_out;
    private int[] int_out;

    public ParallelTempering(double[] dArray, Model[] modelArray) {
        this.temperatures = dArray;
        this.pt_system = modelArray;
        this.n_replicas = this.pt_system.length;
        this.double_out = new double[this.n_replicas];
        this.int_out = new int[this.n_replicas];
        this.replica_swaps = new int[this.n_replicas];
        this.replica_flags = new byte[this.n_replicas];
        for (int i = 0; i < this.n_replicas; ++i) {
            this.replica_swaps[i] = 0;
            this.replica_flags[i] = 0;
            modelArray[i].model_id = i;
        }
        this.replica_flags[0] = 1;
        this.replica_flags[this.n_replicas - 1] = 2;
    }

    public void sample(int n, int n2, int n3) {
        double d = (double)n2 / (double)n3;
        this.lowest_energy = this.lowestEnergy();
        for (int i = 0; i < n; ++i) {
            double d2;
            for (d2 = 0.0; d2 < (double)n2; d2 += d) {
                int n4;
                for (n4 = 0; n4 < this.n_replicas; ++n4) {
                    this.pt_system[n4].temperature = this.temperatures[n4];
                    this.pt_system[n4].mcSweep(d);
                    if (!(this.pt_system[n4].last_energy < this.lowest_energy)) continue;
                    if (this.lowest_en_stream != null) {
                        this.lowest_en_stream.observe(this.pt_system[n4].last_energy);
                    }
                    this.lowest_energy = this.pt_system[n4].last_energy;
                    this.lowest_conformation.set(this.pt_system[n4]);
                }
                if (this.energy_stream != null) {
                    for (n4 = 0; n4 < this.n_replicas; ++n4) {
                        this.double_out[n4] = this.pt_system[n4].last_energy;
                    }
                    this.energy_stream.observe(this.double_out);
                }
                if (this.tra_stream == null || !this.tra_stream.observe()) continue;
                for (n4 = 0; n4 < this.n_replicas; ++n4) {
                    this.pt_system[n4].snapshot(this.tra_stream.getStream());
                }
            }
            int n5 = RandGenerator.randUniform(0, this.n_replicas);
            int n6 = 1 - RandGenerator.randUniform(0, 2) * 2 + n5;
            if (n6 < 0 || n6 == this.n_replicas) {
                this.observeParallelTempering();
                continue;
            }
            double d3 = 1.0 / this.temperatures[n5] - 1.0 / this.temperatures[n6];
            if ((d3 *= this.pt_system[n6].last_energy - this.pt_system[n5].last_energy) < 0.0) {
                Model model = this.pt_system[n5];
                this.pt_system[n5] = this.pt_system[n6];
                this.pt_system[n6] = model;
                int n7 = n5;
                this.replica_swaps[n7] = this.replica_swaps[n7] + 1;
                byte by = this.replica_flags[n5];
                this.replica_flags[n5] = this.replica_flags[n6];
                this.replica_flags[n6] = by;
                this.replica_flags[0] = 1;
                this.replica_flags[this.n_replicas - 1] = 2;
            } else {
                d2 = RandGenerator.randUniform();
                if (d2 < Math.exp(-d3)) {
                    Model model = this.pt_system[n5];
                    this.pt_system[n5] = this.pt_system[n6];
                    this.pt_system[n6] = model;
                    int n8 = n5;
                    this.replica_swaps[n8] = this.replica_swaps[n8] + 1;
                    byte by = this.replica_flags[n5];
                    this.replica_flags[n5] = this.replica_flags[n6];
                    this.replica_flags[n6] = by;
                    this.replica_flags[0] = 1;
                    this.replica_flags[this.n_replicas - 1] = 2;
                }
            }
            this.observeParallelTempering();
        }
    }

    public double lowestEnergy() {
        double d = this.pt_system[0].last_energy;
        for (int i = 1; i < this.n_replicas; ++i) {
            if (!(this.pt_system[i].last_energy < d)) continue;
            d = this.pt_system[i].last_energy;
        }
        return d;
    }

    public void observeParallelTempering() {
        int n;
        if (this.flags_stream != null) {
            for (n = 0; n < this.n_replicas; ++n) {
                this.int_out[n] = this.replica_flags[n];
            }
            this.flags_stream.observe(this.int_out);
        }
        if (this.id_stream != null) {
            for (n = 0; n < this.n_replicas; ++n) {
                this.int_out[this.pt_system[n].model_id] = n;
            }
            this.id_stream.observe(this.int_out);
        }
    }
}

