/*
 * Decompiled with CFR 0.152.
 */
package jbcl.simulations;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import jbcl.util.Format;

public class Observer {
    public int FORMAT_INT_FIELDS = 5;
    public int FORMAT_DOUBLE_FIELDS = 3;
    public int FORMAT_DOUBLE_PRECISION = 2;
    private int lag_time = 1;
    private PrintWriter stream = null;
    private int clock = 0;
    private static String s;

    public Observer(String string, int n) {
        try {
            this.stream = new PrintWriter(new BufferedWriter(new FileWriter(string)));
        }
        catch (IOException iOException) {
            System.out.println("Observer::Observer(): Can't write to file: " + string);
            System.exit(0);
        }
        this.lag_time = n;
    }

    public PrintWriter getStream() {
        return this.stream;
    }

    public boolean observe() {
        ++this.clock;
        if (this.clock == this.lag_time) {
            this.clock = 0;
            return true;
        }
        return false;
    }

    public void observe(String string) {
        ++this.clock;
        if (this.clock == this.lag_time) {
            this.stream.println(string);
            this.clock = 0;
        }
    }

    public void observe(double d) {
        ++this.clock;
        if (this.clock == this.lag_time) {
            this.stream.println(Format.format(d, this.FORMAT_DOUBLE_FIELDS, this.FORMAT_DOUBLE_PRECISION));
            this.clock = 0;
        }
    }

    public void observe(int n) {
        ++this.clock;
        if (this.clock == this.lag_time) {
            this.stream.println(Format.format(n, this.FORMAT_INT_FIELDS));
            this.clock = 0;
        }
    }

    public void observe(int[] nArray) {
        ++this.clock;
        if (this.clock == this.lag_time) {
            s = Format.format(nArray[0], this.FORMAT_INT_FIELDS);
            for (int i = 1; i < nArray.length; ++i) {
                s = s + " " + Format.format(nArray[i], this.FORMAT_INT_FIELDS);
            }
            this.stream.println(s);
            this.clock = 0;
        }
    }

    public void observe(double[] dArray) {
        ++this.clock;
        if (this.clock == this.lag_time) {
            s = Format.format(dArray[0], this.FORMAT_DOUBLE_FIELDS, this.FORMAT_DOUBLE_PRECISION);
            for (int i = 1; i < dArray.length; ++i) {
                s = s + " " + Format.format(dArray[i], this.FORMAT_DOUBLE_FIELDS, this.FORMAT_DOUBLE_PRECISION);
            }
            this.stream.println(s);
            this.clock = 0;
        }
    }

    public void finish() {
        if (this.stream != null) {
            this.stream.close();
        }
    }
}

