/*
 * Decompiled with CFR 0.152.
 */
package jbcl.simulations;

import jbcl.simulations.Model;
import jbcl.simulations.Observer;

public class MetropolisScheme {
    public double lowest_energy;
    public double temperature;
    public Model mc_system;
    public Model lowest_conformation;
    public Observer energy_stream = null;
    public Observer tra_stream = null;

    public MetropolisScheme(double d, Model model) {
        this.temperature = d;
        this.mc_system = model;
    }

    public void sample(int n, int n2) {
        double d = (double)n / (double)n2;
        this.lowest_energy = this.mc_system.last_energy;
        this.mc_system.temperature = this.temperature;
        for (int i = 0; i < n2; ++i) {
            this.mc_system.mcSweep(d);
            if (this.mc_system.last_energy < this.lowest_energy) {
                this.lowest_energy = this.mc_system.last_energy;
                this.lowest_conformation.set(this.mc_system);
            }
            if (this.energy_stream != null) {
                this.energy_stream.observe(this.mc_system.last_energy);
            }
            if (this.tra_stream == null || !this.tra_stream.observe()) continue;
            this.mc_system.snapshot(this.tra_stream.getStream());
        }
    }

    public void simulatedAnnealing(double d, double d2, int n, int n2, int n3) {
        double d3 = (d2 - d) / (double)(n - 1);
        double d4 = (double)n2 / (double)n3;
        this.lowest_energy = this.mc_system.last_energy;
        for (int i = 0; i < n; ++i) {
            this.mc_system.temperature = this.temperature = d + (double)i * d3;
            for (int j = 0; j < n3; ++j) {
                this.mc_system.mcSweep(d4);
                if (this.mc_system.last_energy < this.lowest_energy) {
                    this.lowest_energy = this.mc_system.last_energy;
                    this.lowest_conformation.set(this.mc_system);
                }
                if (this.energy_stream == null) continue;
                this.energy_stream.observe(this.temperature + " " + this.mc_system.last_energy);
            }
        }
    }
}

