/*
 * Decompiled with CFR 0.152.
 */
package jbcl.datatypes;

public class Vector3D {
    public double x;
    public double y;
    public double z;

    public Vector3D() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public Vector3D(double d) {
        this.y = this.z = d;
        this.x = this.z;
    }

    public Vector3D(Vector3D vector3D) {
        this.x = vector3D.x;
        this.y = vector3D.y;
        this.z = vector3D.z;
    }

    public Vector3D(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Vector3D(String string) {
        String[] stringArray = string.trim().split("\\s+");
        this.x = Double.parseDouble(stringArray[0]);
        this.y = Double.parseDouble(stringArray[1]);
        this.z = Double.parseDouble(stringArray[2]);
    }

    public void add(Vector3D vector3D) {
        this.x += vector3D.x;
        this.y += vector3D.y;
        this.z += vector3D.z;
    }

    public void sub(Vector3D vector3D) {
        this.x -= vector3D.x;
        this.y -= vector3D.y;
        this.z -= vector3D.z;
    }

    public double dotProduct(Vector3D vector3D) {
        double d = this.x * vector3D.x;
        d += this.y * vector3D.y;
        return d += this.z * vector3D.z;
    }

    public void add(double d) {
        this.x += d;
        this.y += d;
        this.z += d;
    }

    public void sub(double d) {
        this.x += d;
        this.y += d;
        this.z += d;
    }

    public void mul(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
    }

    public void div(double d) {
        this.x /= d;
        this.y /= d;
        this.z /= d;
    }

    public void set(Vector3D vector3D) {
        this.x = vector3D.x;
        this.y = vector3D.y;
        this.z = vector3D.z;
    }

    public void set(double d) {
        this.x = d;
        this.y = d;
        this.z = d;
    }

    public double distance(Vector3D vector3D) {
        double d = this.x - vector3D.x;
        double d2 = d * d;
        d = this.y - vector3D.y;
        d2 += d * d;
        d = this.z - vector3D.z;
        return Math.sqrt(d2 += d * d);
    }

    public double distanceSquare(Vector3D vector3D) {
        double d = this.x - vector3D.x;
        double d2 = d * d;
        d = this.y - vector3D.y;
        d2 += d * d;
        d = this.z - vector3D.z;
        return d2 += d * d;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public void fromXyzLine(String string) {
        String[] stringArray = string.split(" ");
        this.x = Double.parseDouble(stringArray[0]);
        this.y = Double.parseDouble(stringArray[1]);
        this.z = Double.parseDouble(stringArray[2]);
    }

    public void fromXyzLine(String string, String string2) {
        String[] stringArray = string.split(string2);
        this.x = Double.parseDouble(stringArray[0]);
        this.y = Double.parseDouble(stringArray[1]);
        this.z = Double.parseDouble(stringArray[2]);
    }

    public void fromPdbLine(String string) {
        this.x = Double.parseDouble(string.substring(30, 38));
        this.y = Double.parseDouble(string.substring(38, 46));
        this.z = Double.parseDouble(string.substring(46, 54));
    }

    public void fromDsspLine(String string) {
        this.x = Double.parseDouble(string.substring(107, 114));
        this.y = Double.parseDouble(string.substring(114, 121));
        this.z = Double.parseDouble(string.substring(121, 128));
    }

    public String toString() {
        String string = this.x + " " + this.y + " " + this.z;
        return string;
    }

    public static Vector3D vectorProduct(Vector3D vector3D, Vector3D vector3D2) {
        Vector3D vector3D3 = new Vector3D();
        vector3D3.x = vector3D.y * vector3D2.z - vector3D.z * vector3D2.y;
        vector3D3.y = vector3D.z * vector3D2.x - vector3D.x * vector3D2.z;
        vector3D3.z = vector3D.x * vector3D2.y - vector3D.y * vector3D2.x;
        return vector3D3;
    }

    public static void vectorProduct(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3) {
        vector3D3.x = vector3D.y * vector3D2.z - vector3D.z * vector3D2.y;
        vector3D3.y = vector3D.z * vector3D2.x - vector3D.x * vector3D2.z;
        vector3D3.z = vector3D.x * vector3D2.y - vector3D.y * vector3D2.x;
    }

    public static void main(String[] stringArray) {
        Vector3D vector3D = new Vector3D(1.0);
        Vector3D vector3D2 = new Vector3D(1.0, 2.0, 2.3);
        Vector3D vector3D3 = new Vector3D();
        vector3D3.set(vector3D);
        vector3D3.add(vector3D2);
        System.out.println("(" + vector3D + ")+(" + vector3D2 + ")=(" + vector3D3 + ")");
        vector3D3.fromPdbLine("ATOM      2  CA  CYS A   1     -28.392   5.745  -1.351  0.00 62.05");
        System.out.println("from PDB line: (" + vector3D3 + ")");
        vector3D3.fromDsspLine("   11   11 A E  H  < S+     0   0  136   -4,-1.1  -2,-0.2   1,-0.3  -3,-0.2   0.962 120.4  20.1 -41.2 -44.8   28.9   10.9  -50.3");
        System.out.println("from DSSP line: (" + vector3D3 + ")");
        vector3D3.fromXyzLine("-28.392 5.745 -1.351");
        System.out.println("from XYZ line: (" + vector3D3 + ")");
    }
}

