/*
 * Decompiled with CFR 0.152.
 */
package jbcl.datatypes;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import jbcl.datatypes.Atom;
import jbcl.datatypes.Chain;
import jbcl.datatypes.ResidueAtom;
import jbcl.util.Format;

public class TraFrame
extends Chain {
    public static int N_HEADER_FIELDS = 5;
    public double[] header;
    private static char[] c_seq = new char[0];

    public TraFrame() {
        this.n_atoms = 0;
    }

    public TraFrame(int n) {
        super(n);
    }

    public void createHeader() {
        this.header = new double[N_HEADER_FIELDS];
    }

    public void createHeader(int n) {
        this.header = new double[n];
    }

    public void createHeader(String string) {
        String[] stringArray = string.split("\\s+");
        this.header = new double[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.header[i] = Double.parseDouble(stringArray[i]);
        }
    }

    public boolean fromStrings(String[] stringArray, String string, boolean bl) {
        this.createHeader(stringArray[0]);
        this.n_atoms = 0;
        boolean bl2 = false;
        if (string != null && string.length() > 0) {
            c_seq = string.toCharArray();
            bl2 = true;
        }
        if (bl) {
            double d;
            double d2;
            double d3;
            int n;
            String[] stringArray2 = stringArray[1].split("\\s+");
            for (n = 3; n < stringArray2.length; n += 3) {
                d3 = Double.parseDouble(stringArray2[n]);
                d2 = Double.parseDouble(stringArray2[n + 1]);
                d = Double.parseDouble(stringArray2[n + 2]);
                this.atoms[this.n_atoms] = bl2 ? new ResidueAtom(this.n_atoms + 1, c_seq[this.n_atoms], d3, d2, d) : new Atom(this.n_atoms + 1, d3, d2, d);
                ++this.n_atoms;
            }
            n = 0;
            for (int i = 2; i < stringArray.length; ++i) {
                stringArray2 = stringArray[i].split("\\s+");
                for (int j = 0; j < stringArray2.length; j += 3) {
                    d3 = Double.parseDouble(stringArray2[j]);
                    d2 = Double.parseDouble(stringArray2[j + 1]);
                    d = Double.parseDouble(stringArray2[j + 2]);
                    this.atoms[this.n_atoms] = bl2 ? new ResidueAtom(this.n_atoms + 1, c_seq[this.n_atoms], d3, d2, d) : new Atom(this.n_atoms + 1, d3, d2, d);
                    ++this.n_atoms;
                    if (this.n_atoms != this.atoms.length) continue;
                    n = 1;
                    break;
                }
                if (n != 0) break;
            }
            this.header[1] = this.n_atoms;
        } else {
            this.atoms = new Atom[(int)this.header[1]];
            this.n_atoms = 0;
            for (int i = 1; i < stringArray.length; ++i) {
                String[] stringArray3 = stringArray[i].split("\\s+");
                for (int j = 0; j < stringArray3.length; j += 3) {
                    double d = Double.parseDouble(stringArray3[j]);
                    double d4 = Double.parseDouble(stringArray3[j + 1]);
                    double d5 = Double.parseDouble(stringArray3[j + 2]);
                    this.atoms[this.n_atoms] = bl2 ? new ResidueAtom(this.n_atoms + 1, c_seq[this.n_atoms], d, d4, d5) : new Atom(this.n_atoms + 1, d, d4, d5);
                    ++this.n_atoms;
                }
            }
            this.header[1] = this.n_atoms;
        }
        return true;
    }

    public boolean fromPdbStream(BufferedReader bufferedReader) {
        this.createHeader();
        try {
            String string;
            do {
                if ((string = bufferedReader.readLine()) != null) continue;
                return false;
            } while (string.startsWith("MODEL"));
            this.n_atoms = 0;
            do {
                if (string.length() < 4) continue;
                if (string.charAt(1) != 'T') {
                    if (!string.startsWith("ENDMDL")) continue;
                    break;
                }
                if (string.length() < 40) continue;
                TraFrame.buffer[this.n_atoms] = string;
                ++this.n_atoms;
            } while ((string = bufferedReader.readLine()) != null);
            if (this.n_atoms == 0) {
                return false;
            }
            this.atoms = new Atom[this.n_atoms];
            for (int i = 0; i < this.n_atoms; ++i) {
                this.atoms[i] = new ResidueAtom();
                this.atoms[i].fromPdbLine(buffer[i]);
            }
        }
        catch (IOException iOException) {
            System.out.println("TraFrame::fromPdbStream: Can't read from buffer.");
            System.exit(0);
        }
        this.header[1] = this.n_atoms;
        return true;
    }

    public void toTraStream(PrintWriter printWriter) {
        int n;
        printWriter.print(this.header[0]);
        for (n = 1; n < this.header.length; ++n) {
            printWriter.print(" " + this.header[n]);
        }
        printWriter.println();
        for (n = 0; n < this.n_atoms; ++n) {
            printWriter.print(Format.format(this.atoms[n].x, 4, 3) + " " + Format.format(this.atoms[n].y, 4, 3) + " " + Format.format(this.atoms[n].z, 4, 3) + " ");
            if ((n + 1) % 4 != 0 || n >= this.n_atoms || this.n_atoms <= 2) continue;
            printWriter.println();
        }
        if (this.n_atoms % 4 != 0) {
            printWriter.println();
        }
    }
}

