/*
 * Decompiled with CFR 0.152.
 */
package jbcl.datatypes;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import jbcl.datatypes.TraFrame;
import jbcl.util.Format;

public class Tra {
    public int n_frames;
    public TraFrame[] frames;
    public static int N_MAX_FRAMES = 5000;
    public static boolean IF_DROP_DUMMY = false;
    private static String[] buffer = new String[3000];

    public Tra() {
        this.frames = new TraFrame[N_MAX_FRAMES];
        this.n_frames = 0;
    }

    public Tra(int n) {
        this.frames = new TraFrame[n];
        this.n_frames = 0;
    }

    public boolean fromTraFile(String string, String string2) {
        try {
            String string3;
            int n;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));
            String string4 = bufferedReader.readLine().trim();
            String string5 = bufferedReader.readLine().trim();
            String[] stringArray = string4.split("\\s+");
            int n2 = (int)Double.parseDouble(stringArray[1]);
            stringArray = string5.split("\\s+");
            int n3 = stringArray.length / 3;
            int n4 = (int)Math.ceil((double)n2 / (double)n3) + 1;
            stringArray = new String[n4];
            if (IF_DROP_DUMMY) {
                n2 -= 2;
            }
            stringArray[0] = string4;
            stringArray[1] = string5;
            for (n = 2; n < n4; ++n) {
                stringArray[n] = bufferedReader.readLine().trim();
                if (stringArray[n] != null) continue;
                return false;
            }
            this.frames[0] = new TraFrame(n2);
            this.frames[0].fromStrings(stringArray, string2, IF_DROP_DUMMY);
            this.n_frames = 1;
            n = 0;
            while ((string3 = bufferedReader.readLine()) != null) {
                stringArray[n] = string3.trim();
                if (++n != n4) continue;
                this.frames[this.n_frames] = new TraFrame(n2);
                this.frames[this.n_frames].fromStrings(stringArray, string2, IF_DROP_DUMMY);
                ++this.n_frames;
                n = 0;
                if (this.n_frames != N_MAX_FRAMES) continue;
                System.err.println("Tra::fromTraFile: The maximum number of frames (" + N_MAX_FRAMES + ") was reached");
                break;
            }
        }
        catch (IOException iOException) {
            System.out.println("Tra::fromTraFile: Can't read from a file: " + string);
            System.exit(0);
        }
        return true;
    }

    public void fromPdbFile(String string) {
        try {
            TraFrame traFrame;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));
            this.n_frames = 0;
            while ((traFrame = new TraFrame()).fromPdbStream(bufferedReader)) {
                this.frames[this.n_frames] = traFrame;
                traFrame.header[0] = this.n_frames;
                ++this.n_frames;
                if (this.n_frames != N_MAX_FRAMES) continue;
                System.err.println("Tra::fromPdbFile: The maximum number of frames (" + N_MAX_FRAMES + ") was reached");
                break;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.err.println("Tra::fromPdbFile: Can't find file: " + string);
            System.exit(0);
        }
    }

    public void toTraFile(String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
            for (int i = 0; i < this.n_frames; ++i) {
                this.frames[i].toTraStream(printWriter);
            }
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Tra::toTraFile: File " + string + " cannot be created");
            System.exit(0);
        }
    }

    public void toPdbFile(String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
            for (int i = 0; i < this.n_frames; ++i) {
                printWriter.println("MODEL     " + Format.format(i + 1, 4));
                for (int j = 0; j < this.frames[i].header.length; ++j) {
                    printWriter.println("REMARK   6 HEADER " + Format.format(j + 1, 2) + " " + Format.format(this.frames[i].header[j], 4, 3));
                }
                this.frames[i].toPdbStream(printWriter);
                printWriter.println("ENDMDL");
            }
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Tra::toPdbFile: File " + string + " cannot be created");
            System.exit(0);
        }
    }
}

