/*
 * Decompiled with CFR 0.152.
 */
package jbcl.datatypes;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import jbcl.datatypes.Residue;
import jbcl.util.AaCodes;
import jbcl.util.Format;

public class Sequence {
    public static Residue[] readSeq(String string) {
        Residue[] residueArray;
        Residue[] residueArray2 = new Residue[10000];
        int n = 0;
        try {
            String string2;
            residueArray = new BufferedReader(new FileReader(new File(string)));
            while ((string2 = residueArray.readLine()) != null) {
                residueArray2[n] = new Residue();
                residueArray2[n].fromSeqLine(string2);
                ++n;
            }
        }
        catch (IOException iOException) {
            System.out.println("Sequence::readSeq: Can't find file " + string);
        }
        residueArray = new Residue[n];
        for (n = 0; n < residueArray.length; ++n) {
            residueArray[n] = residueArray2[n];
        }
        return residueArray;
    }

    public static Residue[] readDssp(String string) {
        Residue[] residueArray;
        Residue[] residueArray2 = new Residue[10000];
        int n = 0;
        try {
            String string2;
            residueArray = new BufferedReader(new FileReader(new File(string)));
            while ((string2 = residueArray.readLine()).charAt(2) != '#') {
            }
            while ((string2 = residueArray.readLine()) != null) {
                if (string2.length() < 120 || string2.charAt(13) == '!') continue;
                residueArray2[n] = new Residue();
                residueArray2[n].fromDsspLine(string2);
                ++n;
            }
        }
        catch (IOException iOException) {
            System.out.println("Sequence::readDssp: Can't find file " + string);
        }
        residueArray = new Residue[n];
        for (n = 0; n < residueArray.length; ++n) {
            residueArray[n] = residueArray2[n];
        }
        return residueArray;
    }

    public static String[] readFasta(String string) {
        String[] stringArray;
        boolean bl = false;
        int n = 0;
        String[] stringArray2 = new String[10000];
        try {
            stringArray = new BufferedReader(new FileReader(new File(string)));
            n = 0;
            String string2 = stringArray.readLine();
            if (string2 == null) {
                return null;
            }
            block2: do {
                stringArray2[n * 2] = string2.trim();
                stringArray2[n * 2 + 1] = "";
                string2 = stringArray.readLine();
                if (string2 == null) break;
                while (string2.indexOf(62) == -1) {
                    int n2 = n * 2 + 1;
                    stringArray2[n2] = stringArray2[n2] + string2.trim();
                    string2 = stringArray.readLine();
                    if (string2 != null) continue;
                    bl = true;
                    continue block2;
                }
            } while (!bl && ++n < 5000);
            stringArray.close();
        }
        catch (IOException iOException) {
            System.out.println("Sequence::readFasta: Can't find file: " + string);
        }
        stringArray = new String[2 * n];
        for (int i = 0; i < n * 2; ++i) {
            stringArray[i] = stringArray2[i];
        }
        return stringArray;
    }

    public static void writeSeq(String string, String string2, String string3) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string3));
            byte[] byArray = Sequence.string2Byte(string2);
            for (int i = 0; i < string.length(); ++i) {
                String string4 = Format.format(i + 1, 5) + "   ";
                string4 = string4 + AaCodes.aaName3(string.charAt(i)) + Format.format(byArray[i], 5) + "    0";
                printWriter.println(string4);
            }
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Sequence::writeSeq: Can't write to a file: " + string3);
        }
    }

    public static Residue[] createResidues(String string) {
        Residue[] residueArray = new Residue[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            residueArray[i] = new Residue(i, string.charAt(i));
        }
        return residueArray;
    }

    public static String createStringSequence(Residue[] residueArray) {
        char[] cArray = new char[residueArray.length];
        for (int i = 0; i < residueArray.length; ++i) {
            cArray[i] = residueArray[i].resid_letter;
        }
        return new String(cArray);
    }

    public static byte[] createByteSequence(Residue[] residueArray) {
        byte[] byArray = new byte[residueArray.length];
        for (int i = 0; i < residueArray.length; ++i) {
            byArray[i] = residueArray[i].resid_type;
        }
        return byArray;
    }

    public static String createStringSecStr(Residue[] residueArray) {
        char[] cArray = new char[residueArray.length];
        for (int i = 0; i < residueArray.length; ++i) {
            cArray[i] = AaCodes.ssLetter(residueArray[i].ss_type);
        }
        return new String(cArray);
    }

    public static byte[] createByteSecStr(Residue[] residueArray) {
        byte[] byArray = new byte[residueArray.length];
        for (int i = 0; i < residueArray.length; ++i) {
            byArray[i] = residueArray[i].ss_type;
        }
        return byArray;
    }

    public static byte[] string2Byte(String string) {
        int n = string.length();
        byte[] byArray = new byte[n];
        block22: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case 'G': {
                    byArray[i] = 0;
                    continue block22;
                }
                case 'A': {
                    byArray[i] = 1;
                    continue block22;
                }
                case 'S': {
                    byArray[i] = 2;
                    continue block22;
                }
                case 'C': {
                    byArray[i] = 3;
                    continue block22;
                }
                case 'V': {
                    byArray[i] = 4;
                    continue block22;
                }
                case 'T': {
                    byArray[i] = 5;
                    continue block22;
                }
                case 'I': {
                    byArray[i] = 6;
                    continue block22;
                }
                case 'P': {
                    byArray[i] = 7;
                    continue block22;
                }
                case 'M': {
                    byArray[i] = 8;
                    continue block22;
                }
                case 'D': {
                    byArray[i] = 9;
                    continue block22;
                }
                case 'N': {
                    byArray[i] = 10;
                    continue block22;
                }
                case 'L': {
                    byArray[i] = 11;
                    continue block22;
                }
                case 'K': {
                    byArray[i] = 12;
                    continue block22;
                }
                case 'E': {
                    byArray[i] = 13;
                    continue block22;
                }
                case 'Q': {
                    byArray[i] = 14;
                    continue block22;
                }
                case 'R': {
                    byArray[i] = 15;
                    continue block22;
                }
                case 'H': {
                    byArray[i] = 16;
                    continue block22;
                }
                case 'F': {
                    byArray[i] = 17;
                    continue block22;
                }
                case 'Y': {
                    byArray[i] = 18;
                    continue block22;
                }
                case 'W': {
                    byArray[i] = 19;
                    continue block22;
                }
                default: {
                    byArray[i] = 20;
                }
            }
        }
        return byArray;
    }

    public static String byte2String(int[] nArray) {
        int n = nArray.length;
        char[] cArray = new char[n];
        block22: for (int i = 0; i < n; ++i) {
            switch (nArray[i]) {
                case 0: {
                    cArray[i] = 71;
                    continue block22;
                }
                case 1: {
                    cArray[i] = 65;
                    continue block22;
                }
                case 2: {
                    cArray[i] = 83;
                    continue block22;
                }
                case 3: {
                    cArray[i] = 67;
                    continue block22;
                }
                case 4: {
                    cArray[i] = 86;
                    continue block22;
                }
                case 5: {
                    cArray[i] = 84;
                    continue block22;
                }
                case 6: {
                    cArray[i] = 73;
                    continue block22;
                }
                case 7: {
                    cArray[i] = 80;
                    continue block22;
                }
                case 8: {
                    cArray[i] = 77;
                    continue block22;
                }
                case 9: {
                    cArray[i] = 68;
                    continue block22;
                }
                case 10: {
                    cArray[i] = 78;
                    continue block22;
                }
                case 11: {
                    cArray[i] = 76;
                    continue block22;
                }
                case 12: {
                    cArray[i] = 75;
                    continue block22;
                }
                case 13: {
                    cArray[i] = 69;
                    continue block22;
                }
                case 14: {
                    cArray[i] = 81;
                    continue block22;
                }
                case 15: {
                    cArray[i] = 82;
                    continue block22;
                }
                case 16: {
                    cArray[i] = 72;
                    continue block22;
                }
                case 17: {
                    cArray[i] = 70;
                    continue block22;
                }
                case 18: {
                    cArray[i] = 89;
                    continue block22;
                }
                case 19: {
                    cArray[i] = 87;
                    continue block22;
                }
                default: {
                    cArray[i] = 88;
                }
            }
        }
        return String.copyValueOf(cArray);
    }

    public static byte[] stringSec2Byte(String string) {
        int n = string.length();
        byte[] byArray = new byte[n];
        block5: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case 'C': {
                    byArray[i] = 1;
                    continue block5;
                }
                case 'E': {
                    byArray[i] = 4;
                    continue block5;
                }
                case 'H': {
                    byArray[i] = 2;
                    continue block5;
                }
                default: {
                    byArray[i] = 1;
                }
            }
        }
        return byArray;
    }

    public static String byteSec2String(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n];
        block4: for (int i = 0; i < n; ++i) {
            switch (byArray[i]) {
                case 2: {
                    cArray[i] = 72;
                    continue block4;
                }
                case 4: {
                    cArray[i] = 69;
                    continue block4;
                }
                default: {
                    cArray[i] = 67;
                }
            }
        }
        return String.copyValueOf(cArray);
    }

    public static void main(String[] stringArray) {
        String string = "ASDFESDAD";
        String string2 = "CHHHCEEEC";
        System.out.println("Writting a test SEQ file...");
        Sequence.writeSeq(string, string2, "example.seq");
        System.out.println("Reading that file...");
        Residue[] residueArray = Sequence.readSeq("example.seq");
        String string3 = Sequence.createStringSequence(residueArray);
        String string4 = Sequence.createStringSecStr(residueArray);
        System.out.println("The seqence data in FASTA format is:");
        System.out.println(">example sequence\n" + string3);
        System.out.println(">example sec. struct.\n" + string4);
    }
}

