/*
 * Decompiled with CFR 0.152.
 */
package jbcl.datatypes;

import jbcl.datatypes.Atom;
import jbcl.util.AaCodes;
import jbcl.util.Format;

public class ResidueAtom
extends Atom {
    public int resid_id;
    public byte resid_type;
    public char resid_letter;
    public char chain_letter;
    public char ins_code;

    public ResidueAtom() {
        this.resid_id = 0;
        this.resid_type = (byte)20;
        this.resid_letter = (char)88;
        this.chain_letter = (char)32;
        this.ins_code = (char)32;
    }

    public ResidueAtom(ResidueAtom residueAtom) {
        this.temp_factor = residueAtom.temp_factor;
        this.occ = residueAtom.occ;
        this.resid_id = residueAtom.resid_id;
        this.atom_id = residueAtom.atom_id;
        this.resid_type = residueAtom.resid_type;
        this.chain_letter = residueAtom.chain_letter;
        this.atom_name = residueAtom.atom_name;
        this.alt_loc = residueAtom.alt_loc;
        this.ins_code = residueAtom.ins_code;
        this.resid_letter = residueAtom.resid_letter;
        this.x = residueAtom.x;
        this.y = residueAtom.y;
        this.z = residueAtom.z;
    }

    public void set(ResidueAtom residueAtom) {
        this.temp_factor = residueAtom.temp_factor;
        this.occ = residueAtom.occ;
        this.resid_id = residueAtom.resid_id;
        this.atom_id = residueAtom.atom_id;
        this.resid_type = residueAtom.resid_type;
        this.chain_letter = residueAtom.chain_letter;
        this.atom_name = residueAtom.atom_name;
        this.alt_loc = residueAtom.alt_loc;
        this.ins_code = residueAtom.ins_code;
        this.resid_letter = residueAtom.resid_letter;
        this.x = residueAtom.x;
        this.y = residueAtom.y;
        this.z = residueAtom.z;
    }

    public ResidueAtom(int n, char c, double d, double d2, double d3) {
        this.temp_factor = 100.0;
        this.occ = 0.0;
        this.resid_id = n;
        this.atom_id = n;
        this.resid_type = AaCodes.aaIndex(c);
        this.resid_letter = c;
        this.chain_letter = (char)32;
        this.atom_name = " CA ";
        this.alt_loc = (char)32;
        this.ins_code = (char)32;
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public void fromPdbLine(String string) {
        super.fromPdbLine(string);
        this.chain_letter = string.charAt(21);
        this.ins_code = string.charAt(26);
        this.resid_id = Integer.parseInt(string.substring(22, 26).trim());
        this.resid_type = AaCodes.aaIndex(string.substring(17, 20));
        this.resid_letter = AaCodes.aaName(this.resid_type);
    }

    public int compareTo(ResidueAtom residueAtom) {
        if (this.chain_letter > residueAtom.chain_letter) {
            return 1;
        }
        if (this.chain_letter < residueAtom.chain_letter) {
            return -1;
        }
        if (this.resid_id > residueAtom.resid_id) {
            return 1;
        }
        if (this.resid_id < residueAtom.resid_id) {
            return -1;
        }
        if (this.ins_code > residueAtom.ins_code) {
            return 1;
        }
        if (this.ins_code < residueAtom.ins_code) {
            return -1;
        }
        return this.atom_name.compareTo(residueAtom.atom_name);
    }

    public String toPdbLine() {
        String string = "ATOM  " + Format.format(this.atom_id, 5) + " " + this.atom_name + this.alt_loc + AaCodes.aaName3(this.resid_type) + " " + this.chain_letter + Format.format(this.resid_id, 4) + this.ins_code + "   " + Format.format(this.x, 4, 3) + Format.format(this.y, 4, 3) + Format.format(this.z, 4, 3) + Format.format(this.occ, 3, 2) + Format.format(this.temp_factor, 3, 2);
        return string;
    }

    public static void main(String[] stringArray) {
        String string = "ATOM      2  CA  CYS A   1     -28.392   5.745  -1.351  0.00 62.05";
        ResidueAtom residueAtom = new ResidueAtom();
        residueAtom.fromPdbLine(string);
        System.out.println("Reading a line:\n" + string + "\nResult:\n" + residueAtom.toPdbLine());
    }
}

