/*
 * Decompiled with CFR 0.152.
 */
package jbcl.datatypes;

import java.io.PrintWriter;
import jbcl.datatypes.Atom;
import jbcl.util.AaCodes;
import jbcl.util.Format;

public class Residue {
    public int resid_id;
    public byte resid_type;
    public String resid_name;
    public char resid_letter;
    public char chain_letter;
    public char ins_code;
    public byte ss_type;
    public byte ss_conf;
    public Atom[] atoms;
    public int n_atoms;
    public static final int MAX_ATOMS_IN_RESIDUE = 50;

    public Residue() {
        this.resid_id = 0;
        this.resid_type = (byte)20;
        this.resid_name = "UNK";
        this.resid_letter = (char)88;
        this.chain_letter = (char)32;
        this.ins_code = (char)32;
        this.ss_type = 1;
        this.ss_conf = 0;
        this.n_atoms = 0;
        this.atoms = new Atom[50];
    }

    public Residue(Residue residue) {
        this.resid_id = residue.resid_id;
        this.resid_type = residue.resid_type;
        this.chain_letter = residue.chain_letter;
        this.ins_code = residue.ins_code;
        this.resid_letter = residue.resid_letter;
        this.ss_type = residue.ss_type;
        this.ss_conf = residue.ss_conf;
        this.resid_name = new String(residue.resid_name);
        this.n_atoms = residue.n_atoms;
        this.atoms = new Atom[this.n_atoms];
        for (int i = 0; i < this.n_atoms; ++i) {
            this.atoms[i] = new Atom(residue.atoms[i]);
        }
    }

    public Residue(int n, char c) {
        this.resid_id = n;
        this.resid_type = AaCodes.aaIndex(c);
        this.resid_name = AaCodes.aaName3(this.resid_type);
        this.resid_letter = c;
        this.chain_letter = (char)32;
        this.ins_code = (char)32;
        this.ss_type = 1;
        this.ss_conf = 0;
        this.n_atoms = 0;
        this.atoms = new Atom[AaCodes.nAtoms(this.resid_type) + 1];
    }

    public int compareTo(Residue residue) {
        if (this.chain_letter > residue.chain_letter) {
            return 1;
        }
        if (this.chain_letter < residue.chain_letter) {
            return -1;
        }
        if (this.resid_id > residue.resid_id) {
            return 1;
        }
        if (this.resid_id < residue.resid_id) {
            return -1;
        }
        if (this.ins_code > residue.ins_code) {
            return 1;
        }
        if (this.ins_code < residue.ins_code) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        if (this.chain_letter == ' ') {
            return this.resid_name + this.resid_id;
        }
        return this.chain_letter + ":" + this.resid_name + this.resid_id;
    }

    public void fromPdbLine(String string) {
        this.chain_letter = string.charAt(21);
        this.ins_code = string.charAt(26);
        this.resid_id = Integer.parseInt(string.substring(22, 26).trim());
        this.resid_name = string.substring(17, 20);
        this.resid_type = AaCodes.aaIndex(this.resid_name);
        this.resid_letter = AaCodes.aaName(this.resid_type);
        this.ss_type = 1;
        this.ss_conf = 0;
        this.n_atoms = 0;
        this.atoms = new Atom[AaCodes.nAtoms(this.resid_type) + 1];
    }

    public void toPdbStream(PrintWriter printWriter) {
        for (int i = 0; i < this.n_atoms; ++i) {
            if (this.atoms[i] == null) continue;
            printWriter.println(this.atoms[i].toPdbLine());
        }
    }

    public void fromSeqLine(String string) {
        String[] stringArray = string.trim().split("\\s+");
        this.resid_id = Integer.parseInt(stringArray[0]);
        this.chain_letter = (char)32;
        this.resid_type = AaCodes.aaIndex(stringArray[1]);
        this.resid_letter = AaCodes.aaName(this.resid_type);
        this.resid_name = new String(stringArray[1]);
        this.ss_type = Byte.parseByte(stringArray[2]);
        this.ss_conf = Byte.parseByte(stringArray[3]);
        this.n_atoms = 0;
        this.atoms = new Atom[AaCodes.nAtoms(this.resid_type) + 1];
    }

    public void fromDsspLine(String string) {
        this.resid_letter = string.charAt(13);
        if (Character.isLowerCase(this.resid_letter)) {
            this.resid_letter = (char)67;
        }
        this.resid_id = Integer.parseInt(string.substring(5, 10).trim());
        this.resid_type = AaCodes.aaIndex(this.resid_letter);
        this.resid_name = AaCodes.aaName3(this.resid_type);
        char c = string.charAt(16);
        switch (c) {
            case 'E': {
                this.ss_type = (byte)4;
                break;
            }
            case 'B': {
                this.ss_type = (byte)4;
                break;
            }
            case 'H': {
                this.ss_type = (byte)2;
                break;
            }
            case 'I': {
                this.ss_type = (byte)2;
                break;
            }
            case 'G': {
                this.ss_type = (byte)2;
                break;
            }
            case 'T': {
                this.ss_type = 1;
                break;
            }
            case 'S': {
                this.ss_type = 1;
                break;
            }
            case ' ': {
                this.ss_type = 1;
            }
        }
        this.ss_conf = (byte)9;
        this.chain_letter = string.charAt(11);
        this.ins_code = (char)32;
    }

    public String toSeqLine() {
        String string = Format.format(this.resid_id, 5) + "   " + this.resid_name + Format.format(this.ss_type, 5) + Format.format(this.ss_conf, 5);
        return string;
    }

    public Atom getCa() {
        for (int i = 0; i < this.n_atoms; ++i) {
            if (!Atom.isCa(this.atoms[i])) continue;
            return this.atoms[i];
        }
        return null;
    }

    public Atom[] getBackbone() {
        int n = 0;
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        for (int i = 0; i < this.n_atoms; ++i) {
            if (!Atom.isInBackbone(this.atoms[i])) continue;
            nArray[n] = i;
            ++n;
        }
        Atom[] atomArray = new Atom[n];
        for (int i = 0; i < n; ++i) {
            atomArray[i] = this.atoms[nArray[i]];
        }
        return atomArray;
    }

    public static void main(String[] stringArray) {
        String string = "  124   PHE    1    9";
        Residue residue = new Residue();
        residue.fromSeqLine(string);
        System.out.println("Reading a line:\n" + string + "\nResult:\n" + residue.toSeqLine());
    }
}

