/*
 * Decompiled with CFR 0.152.
 */
package jbcl.datatypes;

import jbcl.datatypes.Atom;
import jbcl.datatypes.Residue;
import jbcl.datatypes.ResidueAtom;
import jbcl.util.Format;

public class PdbAtom
extends Atom {
    public Residue residue;

    public PdbAtom(PdbAtom pdbAtom) {
        super(pdbAtom);
        this.residue = pdbAtom.residue;
    }

    public PdbAtom(Atom atom, Residue residue) {
        super(atom);
        if (residue.n_atoms == residue.atoms.length) {
            System.err.println("PdbAtom::PdbAtom: Too many atoms for a residue:\n" + residue);
            System.exit(0);
        }
        this.residue = residue;
        this.residue.atoms[this.residue.n_atoms] = this;
        ++this.residue.n_atoms;
    }

    public PdbAtom(String string, Residue residue) {
        super.fromPdbLine(string);
        if (residue.n_atoms == residue.atoms.length) {
            System.err.println("PdbAtom::PdbAtom: Too many atoms for a residue:\n" + string);
            System.exit(0);
        }
        this.residue = residue;
        this.residue.atoms[this.residue.n_atoms] = this;
        ++this.residue.n_atoms;
    }

    public void set(PdbAtom pdbAtom) {
        super.set(pdbAtom);
        this.residue = pdbAtom.residue;
    }

    public int compareTo(PdbAtom pdbAtom) {
        int n = this.residue.compareTo(pdbAtom.residue);
        if (n != 0) {
            return n;
        }
        return this.atom_name.compareTo(pdbAtom.atom_name);
    }

    public String toPdbLine() {
        String string = "ATOM  " + Format.format(this.atom_id, 5) + " " + this.atom_name + this.alt_loc + this.residue.resid_name + " " + this.residue.chain_letter + Format.format(this.residue.resid_id, 4) + this.residue.ins_code + "   " + Format.format(this.x, 4, 3) + Format.format(this.y, 4, 3) + Format.format(this.z, 4, 3) + Format.format(this.occ, 3, 2) + Format.format(this.temp_factor, 3, 2);
        return string;
    }

    public static void main(String[] stringArray) {
        String string = "ATOM      2  CA  CYS A   1     -28.392   5.745  -1.351  0.00 62.05";
        ResidueAtom residueAtom = new ResidueAtom();
        residueAtom.fromPdbLine(string);
        System.out.println("Reading a line:\n" + string + "\nResult:\n" + residueAtom.toPdbLine());
    }
}

