/*
 * Decompiled with CFR 0.152.
 */
package jbcl.datatypes;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import jbcl.datatypes.Atom;
import jbcl.datatypes.Chain;
import jbcl.datatypes.CompareStrings;
import jbcl.datatypes.PdbAtom;
import jbcl.datatypes.Residue;

public class Pdb {
    public static boolean SKIP_HETEROATOMS;
    public static boolean SKIP_WATER;
    public static boolean SKIP_HYDROGENS;
    public static boolean SKIP_ALTERNATE_ATOMS;
    public static int MAX_BUFFER_CAPACITY;
    public static String[] buffer;
    public static int n_lines;
    private int n_chains;
    private Chain[] chains;
    private int n_residues;
    private Residue[] residues;
    private Residue[][] chained_residues;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void loadPdbToBuffer(String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));
            n_lines = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() < 4) continue;
                if (string2.charAt(0) == 'E') {
                    if (!string2.startsWith("ENDMDL")) continue;
                    break;
                }
                if (string2.length() < 40 || !string2.startsWith("ATO") && (!string2.startsWith("HETA") || SKIP_HETEROATOMS) || SKIP_ALTERNATE_ATOMS && string2.charAt(16) != 'A' && string2.charAt(16) != ' ' || SKIP_HYDROGENS && string2.charAt(13) == 'H' || SKIP_WATER && string2.substring(17, 20).compareTo("HOH") == 0) continue;
                Pdb.buffer[Pdb.n_lines] = string2;
                ++n_lines;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("Pdb::loadPdbToBuffer: Can't find file: " + string);
            System.exit(0);
        }
    }

    public static void sortPdbBuffer() {
        Arrays.sort(buffer, 0, n_lines, new CompareStrings());
    }

    public void fromPdbBuffer() {
        int n;
        Pdb.sortPdbBuffer();
        this.createChains();
        this.createResidues();
        Chain chain = this.chains[0];
        Residue residue = null;
        char c = chain.chain_letter;
        String string = "";
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[this.n_chains];
        this.n_residues = 0;
        for (n = 0; n < n_lines; ++n) {
            String string2;
            if (c != buffer[n].charAt(21)) {
                n2 = 0;
                chain = this.getChain(buffer[n].charAt(21));
                c = chain.chain_letter;
                nArray[++n3] = 0;
            }
            if ((string2 = buffer[n].substring(17, 27)).compareTo(string) != 0) {
                residue = new Residue();
                residue.fromPdbLine(buffer[n]);
                this.residues[this.n_residues] = residue;
                ++this.n_residues;
                int n4 = n3;
                nArray[n4] = nArray[n4] + 1;
                string = string2;
            }
            chain.atoms[n2] = new PdbAtom(buffer[n], residue);
            ++n2;
        }
        this.chained_residues = new Residue[this.n_chains][];
        for (n = 0; n < this.n_chains; ++n) {
            this.chained_residues[n] = new Residue[nArray[n]];
            char c2 = this.chains[n].chain_letter;
            int n5 = 0;
            for (int i = 0; i < this.n_residues; ++i) {
                if (this.residues[i].chain_letter != c2) continue;
                this.chained_residues[n][n5] = this.residues[i];
                ++n5;
            }
            if (!$assertionsDisabled && n5 != nArray[n]) {
                throw new AssertionError();
            }
        }
    }

    public void fromPdbFile(String string) {
        Pdb.loadPdbToBuffer(string);
        this.fromPdbBuffer();
    }

    public void fromXyzFile(String string, String string2) {
        this.chains = new Chain[1];
        this.chains[0] = new Chain();
        this.chains[0].fromXyzFile(string);
        if (string2 == null) {
            this.residues = new Residue[this.chains[0].n_atoms];
            for (int i = 0; i < this.chains[0].n_atoms; ++i) {
                this.residues[i] = new Residue(i + 1, 'X');
                PdbAtom pdbAtom = new PdbAtom(this.chains[0].atoms[i], this.residues[i]);
            }
        } else {
            if (this.chains[0].n_atoms != string2.length()) {
                System.err.println("Pdb::fromXyzFile: Given sequence has different length than number of atoms in " + string + " file");
                System.exit(0);
            }
            this.residues = new Residue[this.chains[0].n_atoms];
            for (int i = 0; i < this.chains[0].n_atoms; ++i) {
                this.residues[i] = new Residue(i + 1, string2.charAt(i));
                PdbAtom pdbAtom = new PdbAtom(this.chains[0].atoms[i], this.residues[i]);
            }
        }
        this.n_residues = this.residues.length;
        this.n_chains = 1;
        this.chained_residues = new Residue[this.n_chains][];
        this.chained_residues[0] = this.residues;
    }

    public void toPdbFile(String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
            for (int i = 0; i < this.n_chains; ++i) {
                this.chains[i].toPdbStream(printWriter);
            }
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Pdb::toPdbFile: File " + string + " cannot be created");
            System.exit(0);
        }
    }

    public int countChains() {
        return this.n_chains;
    }

    public int countResidues() {
        return this.n_residues;
    }

    public int countResidues(char c) {
        return this.chained_residues[this.getChainIndex(c)].length;
    }

    public Chain getChain(char c) {
        for (int i = 0; i < this.n_chains; ++i) {
            if (this.chains[i].chain_letter != c) continue;
            return this.chains[i];
        }
        return null;
    }

    public char[] getChainIds() {
        char[] cArray = new char[this.n_chains];
        for (int i = 0; i < this.n_chains; ++i) {
            cArray[i] = this.chains[i].chain_letter;
        }
        return cArray;
    }

    public Chain getCaChain(char c) {
        Chain chain = this.chains[this.getChainIndex(c)];
        int n = 0;
        for (int i = 0; i < chain.n_atoms; ++i) {
            if (!Atom.isCa(chain.atoms[i])) continue;
            ++n;
        }
        Chain chain2 = new Chain(n);
        n = 0;
        for (int i = 0; i < chain.n_atoms; ++i) {
            if (!Atom.isCa(chain.atoms[i])) continue;
            chain2.atoms[n] = chain.atoms[i];
            ++n;
        }
        chain2.chain_letter = chain.chain_letter;
        return chain2;
    }

    public Chain getBbChain(char c) {
        Chain chain = this.chains[this.getChainIndex(c)];
        int n = 0;
        for (int i = 0; i < chain.n_atoms; ++i) {
            if (!Atom.isInBackbone(chain.atoms[i])) continue;
            ++n;
        }
        Chain chain2 = new Chain(n);
        n = 0;
        for (int i = 0; i < chain.n_atoms; ++i) {
            if (!Atom.isInBackbone(chain.atoms[i])) continue;
            chain2.atoms[n] = chain.atoms[i];
            ++n;
        }
        chain2.chain_letter = chain.chain_letter;
        return chain2;
    }

    public Residue[] getResidues() {
        return this.residues;
    }

    public Residue[] getResidues(char c) {
        return this.chained_residues[this.getChainIndex(c)];
    }

    public Residue[] getResidues(int[] nArray, char c) {
        int n = 0;
        while (n < nArray.length) {
            int n2 = n++;
            nArray[n2] = nArray[n2] - 1;
        }
        Residue[] residueArray = new Residue[nArray.length];
        Residue[] residueArray2 = this.chained_residues[this.getChainIndex(c)];
        int n3 = 0;
        while (n3 < nArray.length) {
            residueArray[n3] = residueArray2[nArray[n3]];
            int n4 = n3++;
            nArray[n4] = nArray[n4] + 1;
        }
        return residueArray;
    }

    public static void main(String[] stringArray) {
        Pdb pdb = new Pdb();
        if (stringArray.length >= 1) {
            int n;
            pdb.fromPdbFile(stringArray[0]);
            char[] cArray = pdb.getChainIds();
            System.out.print("Chains: ");
            for (n = 0; n < cArray.length; ++n) {
                System.out.println(">" + cArray[n] + "< " + pdb.countResidues(cArray[n]) + " residues");
            }
            System.out.println("\nResidues: ( total: " + pdb.countResidues() + ")");
            for (n = 0; n < pdb.countResidues(); ++n) {
                System.out.println(pdb.residues[n].toSeqLine());
            }
            System.out.println("Residues and their atoms: ");
            Residue[] residueArray = pdb.getResidues();
            for (int i = 0; i < residueArray.length; ++i) {
                System.out.print(residueArray[i].toSeqLine() + " : ");
                for (int j = 0; j < residueArray[i].n_atoms; ++j) {
                    System.out.print(residueArray[i].atoms[j].atom_id + " ");
                }
                System.out.println();
            }
            if (stringArray.length == 2) {
                System.out.println("Saving PDB file to: " + stringArray[1]);
                pdb.toPdbFile(stringArray[1]);
            }
        }
    }

    private void createChains() {
        int n;
        char[] cArray = new char[30];
        int[] nArray = new int[30];
        char c = '}';
        this.n_chains = -1;
        for (n = 0; n < n_lines; ++n) {
            char c2 = buffer[n].charAt(21);
            if (c != c2) {
                ++this.n_chains;
                c = c2;
                cArray[this.n_chains] = c2;
                nArray[this.n_chains] = 1;
                continue;
            }
            int n2 = this.n_chains;
            nArray[n2] = nArray[n2] + 1;
        }
        ++this.n_chains;
        this.chains = new Chain[this.n_chains];
        for (n = 0; n < this.n_chains; ++n) {
            this.chains[n] = new Chain(nArray[n]);
            this.chains[n].chain_letter = cArray[n];
        }
    }

    private void createResidues() {
        int n = 0;
        String string = "";
        for (int i = 0; i < n_lines; ++i) {
            String string2 = buffer[i].substring(17, 27);
            if (string2.compareTo(string) == 0) continue;
            ++n;
            string = string2;
        }
        this.residues = new Residue[n];
    }

    private int getChainIndex(char c) {
        for (int i = 0; i < this.n_chains; ++i) {
            if (this.chains[i].chain_letter != c) continue;
            return i;
        }
        return -1;
    }

    static {
        $assertionsDisabled = !Pdb.class.desiredAssertionStatus();
        SKIP_HETEROATOMS = false;
        SKIP_WATER = true;
        SKIP_HYDROGENS = true;
        SKIP_ALTERNATE_ATOMS = true;
        MAX_BUFFER_CAPACITY = 100000;
        buffer = new String[MAX_BUFFER_CAPACITY];
        n_lines = 0;
    }
}

