/*
 * Decompiled with CFR 0.152.
 */
package jbcl.datatypes;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import jbcl.datatypes.Atom;
import jbcl.datatypes.ResidueAtom;
import jbcl.datatypes.Vector3D;

public class Chain {
    public static boolean CA_ONLY = true;
    public static boolean SKIP_HETEROATOMS = true;
    public static boolean SKIP_INSERTED_RESIDUES = false;
    public int n_atoms;
    public Atom[] atoms;
    public char chain_letter = (char)32;
    protected static final String[] buffer = new String[10000];

    public Chain() {
        this.n_atoms = 0;
    }

    public Chain(int n) {
        this.n_atoms = n;
        this.atoms = new Atom[this.n_atoms];
    }

    public void add(Vector3D vector3D) {
        for (int i = 0; i < this.n_atoms; ++i) {
            this.atoms[i].add(vector3D);
        }
    }

    public void sub(Vector3D vector3D) {
        for (int i = 0; i < this.n_atoms; ++i) {
            this.atoms[i].sub(vector3D);
        }
    }

    public void add(double d) {
        for (int i = 0; i < this.n_atoms; ++i) {
            this.atoms[i].add(d);
        }
    }

    public void sub(double d) {
        for (int i = 0; i < this.n_atoms; ++i) {
            this.atoms[i].sub(d);
        }
    }

    public void mul(double d) {
        for (int i = 0; i < this.n_atoms; ++i) {
            this.atoms[i].mul(d);
        }
    }

    public void div(double d) {
        for (int i = 0; i < this.n_atoms; ++i) {
            this.atoms[i].div(d);
        }
    }

    public void fromPdbFile(String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));
            this.n_atoms = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() < 4) continue;
                if (string2.charAt(3) != 'M' && string2.charAt(3) != 'E') {
                    if (!string2.startsWith("ENDMDL")) continue;
                    break;
                }
                if (string2.length() < 40 || !string2.startsWith("ATO") && (!string2.startsWith("HETA") || SKIP_HETEROATOMS) || string2.charAt(16) != 'A' && string2.charAt(16) != ' ' || string2.charAt(13) == 'H' || CA_ONLY && (string2.charAt(13) != 'C' || string2.charAt(14) != 'A')) continue;
                Chain.buffer[this.n_atoms] = string2;
                ++this.n_atoms;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("Chain::fromPdbFile: Can't find file: " + string);
            System.exit(0);
        }
        this.atoms = new Atom[this.n_atoms];
        for (int i = 0; i < this.n_atoms; ++i) {
            this.atoms[i] = new ResidueAtom();
            this.atoms[i].fromPdbLine(buffer[i]);
        }
        ResidueAtom residueAtom = (ResidueAtom)this.atoms[this.n_atoms - 1];
        this.chain_letter = residueAtom.chain_letter;
    }

    public void toPdbStream(PrintWriter printWriter) {
        for (int i = 0; i < this.n_atoms; ++i) {
            printWriter.println(this.atoms[i].toPdbLine());
        }
    }

    public void toPdbFile(String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
            this.toPdbStream(printWriter);
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Chain::toPdbFile: File " + string + " cannot be created");
            System.exit(0);
        }
    }

    public void fromXyzFile(String string) {
        String string2;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));
            this.n_atoms = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() < 6 || string2.charAt(0) == '#') continue;
                Chain.buffer[this.n_atoms] = string2;
                ++this.n_atoms;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("Chain::fromXyzFile: Can't find file: " + string);
            System.exit(0);
        }
        this.atoms = new Atom[this.n_atoms];
        string2 = "";
        try {
            for (int i = 0; i < this.n_atoms; ++i) {
                string2 = buffer[i];
                Vector3D vector3D = new Vector3D(string2);
                this.atoms[i] = new Atom(i, vector3D.x, vector3D.y, vector3D.z);
            }
        }
        catch (Exception exception) {
            System.err.println("Chain::fromXyzFile exception:");
            System.err.println(exception);
            System.err.println("Last data line was: " + string2);
            System.exit(0);
        }
    }

    public void toXyzFile(String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
            this.toXyzStream(printWriter);
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Chain::toXyzFile: File " + string + " cannot be created");
            System.exit(0);
        }
    }

    public void toXyzStream(PrintWriter printWriter) {
        printWriter.println("# " + this.n_atoms);
        for (int i = 0; i < this.n_atoms; ++i) {
            printWriter.println(this.atoms[i].x + " " + this.atoms[i].y + " " + this.atoms[i].z);
        }
    }
}

