/*
 * Decompiled with CFR 0.152.
 */
package jbcl.datatypes;

import jbcl.datatypes.Vector3D;
import jbcl.util.Format;

public class Atom
extends Vector3D {
    public double temp_factor;
    public int atom_id;
    public String atom_name;
    public char alt_loc;
    public double occ;

    public Atom() {
        this.temp_factor = 0.0;
        this.occ = 0.0;
        this.atom_id = 0;
        this.atom_name = " CA ";
        this.alt_loc = (char)32;
    }

    public Atom(Atom atom) {
        this.temp_factor = atom.temp_factor;
        this.occ = atom.occ;
        this.atom_id = atom.atom_id;
        this.atom_name = new String(atom.atom_name);
        this.alt_loc = atom.alt_loc;
        this.x = atom.x;
        this.y = atom.y;
        this.z = atom.z;
    }

    public void set(Atom atom) {
        super.set(atom);
        this.temp_factor = atom.temp_factor;
        this.occ = atom.occ;
        this.atom_id = atom.atom_id;
        this.atom_name = new String(atom.atom_name);
        this.alt_loc = atom.alt_loc;
    }

    public Atom(int n, double d, double d2, double d3) {
        this.temp_factor = 100.0;
        this.occ = 0.0;
        this.atom_id = n;
        this.atom_name = " CA ";
        this.alt_loc = (char)32;
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public void fromPdbLine(String string) {
        super.fromPdbLine(string);
        this.atom_id = Integer.parseInt(string.substring(6, 11).trim());
        this.atom_name = string.substring(12, 16);
        this.alt_loc = string.charAt(16);
        if (string.length() >= 66) {
            this.occ = Double.parseDouble(string.substring(54, 60).trim());
            this.temp_factor = Double.parseDouble(string.substring(60, 66).trim());
        }
    }

    public String toPdbLine() {
        String string = "ATOM  " + Format.format(this.atom_id, 5) + " " + this.atom_name + this.alt_loc + "UNK" + " " + ' ' + Format.format(this.atom_id, 4) + ' ' + "   " + Format.format(this.x, 4, 3) + Format.format(this.y, 4, 3) + Format.format(this.z, 4, 3) + Format.format(this.occ, 3, 2) + Format.format(this.temp_factor, 3, 2);
        return string;
    }

    public int compareTo(Atom atom) {
        return this.atom_name.compareTo(atom.atom_name);
    }

    public static boolean isCa(Atom atom) {
        return atom.atom_name.compareTo(" CA ") == 0;
    }

    public static boolean isInBackbone(Atom atom) {
        if (atom.atom_name.compareTo(" N  ") == 0) {
            return true;
        }
        if (atom.atom_name.compareTo(" O  ") == 0) {
            return true;
        }
        if (atom.atom_name.compareTo(" C  ") == 0) {
            return true;
        }
        return atom.atom_name.compareTo(" CA ") == 0;
    }

    public static void main(String[] stringArray) {
        String string = "ATOM      2  CA  CYS A   1     -28.392   5.745  -1.351  0.00 62.05";
        Atom atom = new Atom();
        atom.fromPdbLine(string);
        System.out.println("Reading a line:\n" + string + "\nResult:\n" + atom.toPdbLine());
    }
}

