/*
 * Decompiled with CFR 0.152.
 */
package jbcl.calc.functions;

import jbcl.calc.functions.Function;

public class NormalDistribution
implements Function {
    private double pi2s = Math.sqrt(Math.PI * 2);
    private double e = 0.0;
    private double s = 1.0;
    private double s2 = 1.0;

    public static double evaluate(double d, double d2, double d3) {
        double d4 = d - d2;
        return Math.exp(-d4 * d4 / (2.0 * d3 * d3)) / (d3 * Math.sqrt(Math.PI * 2));
    }

    public NormalDistribution(double d, double d2) {
        this.e = d;
        this.s = d2;
        this.s2 = 2.0 * this.s * this.s;
        this.pi2s = Math.sqrt(Math.PI * 2) * this.s;
    }

    public double evaluate(double d) {
        double d2 = d - this.e;
        return Math.exp(-d2 * d2 / this.s2) / this.pi2s;
    }
}

