/*
 * Decompiled with CFR 0.152.
 */
package jbcl.calc;

import jbcl.datatypes.Atom;
import jbcl.datatypes.Vector3D;
import jbcl.util.Format;

public class InternalSystem {
    public static Vector3D[][] getVersors(Vector3D[] vector3DArray) {
        int n = vector3DArray.length;
        if (n <= 2) {
            return null;
        }
        Vector3D[][] vector3DArray2 = new Vector3D[n][];
        Vector3D vector3D = InternalSystem.calcEndDummy(vector3DArray[0], vector3DArray[1], vector3DArray[2]);
        vector3DArray2[0] = InternalSystem.getVersors(vector3D, vector3DArray[0], vector3DArray[1]);
        for (int i = 1; i < n - 1; ++i) {
            vector3DArray2[i] = InternalSystem.getVersors(vector3DArray[i - 1], vector3DArray[i], vector3DArray[i + 1]);
        }
        vector3D = InternalSystem.calcEndDummy(vector3DArray[n - 3], vector3DArray[n - 2], vector3DArray[n - 1]);
        vector3DArray2[n - 1] = InternalSystem.getVersors(vector3DArray[n - 2], vector3DArray[n - 1], vector3D);
        return vector3DArray2;
    }

    public static Vector3D[] getVersors(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3) {
        Vector3D vector3D4 = new Vector3D(vector3D2);
        vector3D4.sub(vector3D);
        vector3D4.div(vector3D4.length());
        Vector3D vector3D5 = new Vector3D(vector3D2);
        vector3D5.sub(vector3D3);
        vector3D5.div(vector3D5.length());
        Vector3D[] vector3DArray = new Vector3D[3];
        vector3DArray[1] = new Vector3D(vector3D4);
        vector3DArray[1].add(vector3D5);
        vector3DArray[1].div(vector3DArray[1].length());
        vector3DArray[0] = new Vector3D(vector3D4);
        vector3DArray[0].sub(vector3D5);
        vector3DArray[0].div(vector3DArray[0].length());
        vector3DArray[2] = Vector3D.vectorProduct(vector3DArray[0], vector3DArray[1]);
        return vector3DArray;
    }

    public static void getVersors(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, Vector3D[] vector3DArray) {
        Vector3D vector3D4 = new Vector3D(vector3D2);
        vector3D4.sub(vector3D);
        vector3D4.div(vector3D4.length());
        Vector3D vector3D5 = new Vector3D(vector3D2);
        vector3D5.sub(vector3D3);
        vector3D5.div(vector3D5.length());
        vector3DArray[1].set(vector3D4);
        vector3DArray[1].add(vector3D5);
        vector3DArray[1].div(vector3DArray[1].length());
        vector3DArray[0].set(vector3D4);
        vector3DArray[0].sub(vector3D5);
        vector3DArray[0].div(vector3DArray[0].length());
        Vector3D.vectorProduct(vector3DArray[0], vector3DArray[1], vector3DArray[2]);
    }

    public static void transposeVersors(Vector3D[] vector3DArray, Vector3D[] vector3DArray2) {
        vector3DArray2[0].x = vector3DArray[0].x;
        vector3DArray2[0].y = vector3DArray[1].x;
        vector3DArray2[0].z = vector3DArray[2].x;
        vector3DArray2[1].x = vector3DArray[0].y;
        vector3DArray2[1].y = vector3DArray[1].y;
        vector3DArray2[1].z = vector3DArray[2].y;
        vector3DArray2[2].x = vector3DArray[0].z;
        vector3DArray2[2].y = vector3DArray[1].z;
        vector3DArray2[2].z = vector3DArray[2].z;
    }

    public static Vector3D calcFrontDummy(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3) {
        Vector3D vector3D4 = new Vector3D(vector3D);
        vector3D4.sub(vector3D3);
        vector3D4.add(vector3D2);
        return vector3D4;
    }

    public static Vector3D calcEndDummy(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3) {
        Vector3D vector3D4 = new Vector3D(vector3D3);
        vector3D4.sub(vector3D);
        vector3D4.add(vector3D2);
        return vector3D4;
    }

    public static Atom amideHydrogen(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3) {
        Vector3D vector3D4 = new Vector3D(vector3D2);
        vector3D4.sub(vector3D);
        vector3D4.div(vector3D4.length());
        Vector3D vector3D5 = new Vector3D(vector3D2);
        vector3D5.sub(vector3D3);
        vector3D5.div(vector3D5.length());
        vector3D5.add(vector3D4);
        vector3D5.div(vector3D5.length());
        vector3D5.add(vector3D2);
        Atom atom = new Atom(0, vector3D5.x, vector3D5.y, vector3D5.z);
        atom.atom_name = new String(" H  ");
        return atom;
    }

    public static void amideHydrogen(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, Atom atom) {
        Vector3D vector3D4 = new Vector3D(vector3D2);
        vector3D4.sub(vector3D);
        vector3D4.div(vector3D4.length());
        Vector3D vector3D5 = new Vector3D(vector3D2);
        vector3D5.sub(vector3D3);
        vector3D5.div(vector3D5.length());
        vector3D5.add(vector3D4);
        vector3D5.div(vector3D5.length());
        vector3D5.add(vector3D2);
        atom.x = vector3D5.x;
        atom.y = vector3D5.y;
        atom.z = vector3D5.z;
    }

    public static void main(String[] stringArray) {
        Vector3D[] vector3DArray = new Vector3D[]{new Vector3D(1.0, 1.0, 1.0), new Vector3D(2.0, 2.0, 2.0), new Vector3D(3.0, 3.0, 1.0), new Vector3D(4.0, 3.0, 2.0)};
        System.out.println("Data points:");
        for (int i = 0; i < 4; ++i) {
            System.out.println(i + " " + Format.format(vector3DArray[i], 2, 3));
        }
        Vector3D[][] vector3DArray2 = InternalSystem.getVersors(vector3DArray);
        System.out.println("Internal coordinations systems:");
        for (int i = 0; i < 4; ++i) {
            System.out.println(i + " " + Format.format(vector3DArray2[i][0], 2, 3) + " " + Format.format(vector3DArray2[i][1], 2, 3) + " " + Format.format(vector3DArray2[i][2], 2, 3));
        }
        System.out.println("Position of the points [0],[1],[2] and [3] in the system [1]:");
        Vector3D vector3D = new Vector3D();
        Vector3D vector3D2 = new Vector3D();
        for (int i = 0; i < 4; ++i) {
            vector3D2.set(vector3DArray[i]);
            vector3D2.sub(vector3DArray[1]);
            vector3D.x = vector3D2.dotProduct(vector3DArray2[1][0]);
            vector3D.y = vector3D2.dotProduct(vector3DArray2[1][1]);
            vector3D.z = vector3D2.dotProduct(vector3DArray2[1][2]);
            System.out.println(Format.format(vector3D, 2, 3));
        }
    }
}

