/*
 * Decompiled with CFR 0.152.
 */
package jbcl.calc;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import jbcl.datatypes.Atom;
import jbcl.datatypes.TraFrame;
import jbcl.datatypes.Vector3D;
import jbcl.statistics.RandGenerator;
import jbcl.util.Format;
import jbcl.util.Selector;

public class Distances {
    public static boolean INDEX_FROM_ONE = false;

    public static void distanceMatrix(Atom[] atomArray, double[][] dArray) {
        int n = atomArray.length;
        for (int i = 1; i < n; ++i) {
            Atom atom = atomArray[i];
            for (int j = 0; j < i; ++j) {
                double d = atom.distance(atomArray[j]);
                dArray[j][i] = d;
                dArray[i][j] = d;
            }
        }
    }

    public static double minDistance(Atom[] atomArray, Atom[] atomArray2) {
        int n = atomArray.length;
        int n2 = atomArray2.length;
        double d = 10000.0;
        for (int i = 0; i < n; ++i) {
            Atom atom = atomArray[i];
            for (int j = 0; j < n2; ++j) {
                double d2 = atom.distanceSquare(atomArray2[j]);
                if (!(d2 < d)) continue;
                d = d2;
            }
        }
        return Math.sqrt(d);
    }

    public static double minDistance(Atom[] atomArray, Atom[] atomArray2, Selector selector) {
        int n = atomArray.length;
        int n2 = atomArray2.length;
        double d = 10000.0;
        for (int i = 0; i < n; ++i) {
            if (!selector.select(atomArray[i])) continue;
            Atom atom = atomArray[i];
            for (int j = 0; j < n2; ++j) {
                double d2;
                if (!selector.select(atomArray2[j]) || !((d2 = atom.distanceSquare(atomArray2[j])) < d)) continue;
                d = d2;
            }
        }
        return Math.sqrt(d);
    }

    public static void distanceSquareMatrix(Atom[] atomArray, double[][] dArray) {
        int n = atomArray.length;
        for (int i = 1; i < n; ++i) {
            Atom atom = atomArray[i];
            for (int j = 0; j < i; ++j) {
                double d = atom.distanceSquare(atomArray[j]);
                dArray[j][i] = d;
                dArray[i][j] = d;
            }
        }
    }

    public static void printDistanceMap(double[][] dArray, String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
            int n = 0;
            if (INDEX_FROM_ONE) {
                n = 1;
            }
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray.length; ++j) {
                    if (i <= j) {
                        printWriter.println(Format.format(i + n, 5) + Format.format(j + n, 5) + " " + Format.format(dArray[i][j], 3, 3) + " " + Format.format(dArray[j][i], 3, 3));
                        continue;
                    }
                    printWriter.println(Format.format(i + n, 5) + Format.format(j + n, 5) + " " + Format.format(dArray[j][i], 3, 3) + " " + Format.format(dArray[i][j], 3, 3));
                }
            }
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Trac::printDistanceMap: File " + string + " cannot be created");
            System.exit(0);
        }
    }

    public static void printDistanceMap(double[][] dArray) {
        int n = 0;
        if (INDEX_FROM_ONE) {
            n = 1;
        }
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                if (i <= j) {
                    System.out.println(Format.format(i + n, 4) + Format.format(j + n, 4) + " " + Format.format(dArray[i][j], 3, 3) + " " + Format.format(dArray[j][i], 3, 3));
                    continue;
                }
                System.out.println(Format.format(i + n, 4) + Format.format(j + n, 4) + " " + Format.format(dArray[j][i], 3, 3) + " " + Format.format(dArray[i][j], 3, 3));
            }
        }
    }

    public static void printDistanceMap(double[][] dArray, String[] stringArray, String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
            boolean bl = false;
            if (INDEX_FROM_ONE) {
                bl = true;
            }
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray.length; ++j) {
                    if (i <= j) {
                        printWriter.println(stringArray[i] + " " + stringArray[j] + " " + Format.format(dArray[i][j], 3, 3) + " " + Format.format(dArray[j][i], 3, 3));
                        continue;
                    }
                    printWriter.println(stringArray[i] + " " + stringArray[j] + " " + Format.format(dArray[j][i], 3, 3) + " " + Format.format(dArray[i][j], 3, 3));
                }
            }
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Trac::printDistanceMap: File " + string + " cannot be created");
            System.exit(0);
        }
    }

    public static void printDistanceMap(double[][] dArray, String[] stringArray) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                if (i <= j) {
                    System.out.println(stringArray[i] + " " + stringArray[j] + " " + Format.format(dArray[i][j], 3, 3) + " " + Format.format(dArray[j][i], 3, 3));
                    continue;
                }
                System.out.println(stringArray[i] + " " + stringArray[j] + " " + Format.format(dArray[j][i], 3, 3) + " " + Format.format(dArray[i][j], 3, 3));
            }
        }
    }

    public static int sign(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, Vector3D vector3D4) {
        Vector3D vector3D5 = new Vector3D(vector3D2);
        vector3D5.sub(vector3D);
        Vector3D vector3D6 = new Vector3D(vector3D3);
        vector3D6.sub(vector3D2);
        Vector3D vector3D7 = new Vector3D(vector3D4);
        vector3D7.sub(vector3D3);
        if (Distances.det3(vector3D5.x, vector3D5.y, vector3D5.z, vector3D6.x, vector3D6.y, vector3D6.z, vector3D7.x, vector3D7.y, vector3D7.z) < 0.0) {
            return -1;
        }
        return 1;
    }

    public static double[] r14x(Vector3D[] vector3DArray) {
        if (vector3DArray.length <= 3) {
            return null;
        }
        double[] dArray = new double[vector3DArray.length - 3];
        for (int i = 0; i < vector3DArray.length - 3; ++i) {
            double d = vector3DArray[i].x - vector3DArray[i + 3].x;
            double d2 = vector3DArray[i].y - vector3DArray[i + 3].y;
            double d3 = vector3DArray[i].z - vector3DArray[i + 3].z;
            double d4 = Distances.det3(-vector3DArray[i].x + vector3DArray[i + 1].x, -vector3DArray[i].y + vector3DArray[i + 1].y, -vector3DArray[i].z + vector3DArray[i + 1].z, -vector3DArray[i + 1].x + vector3DArray[i + 2].x, -vector3DArray[i + 1].y + vector3DArray[i + 2].y, -vector3DArray[i + 1].z + vector3DArray[i + 2].z, -vector3DArray[i + 2].x + vector3DArray[i + 3].x, -vector3DArray[i + 2].y + vector3DArray[i + 3].y, -vector3DArray[i + 2].z + vector3DArray[i + 3].z);
            dArray[i] = d4 < 0.0 ? Math.sqrt(d * d + d2 * d2 + d3 * d3) * -1.0 : Math.sqrt(d * d + d2 * d2 + d3 * d3);
        }
        return dArray;
    }

    public static double[] r1K(Vector3D[] vector3DArray, int n) {
        int n2 = n - 1;
        if (vector3DArray.length <= n2) {
            return null;
        }
        double[] dArray = new double[vector3DArray.length - n2];
        for (int i = 0; i < vector3DArray.length - n2; ++i) {
            double d = vector3DArray[i].x - vector3DArray[i + n2].x;
            double d2 = vector3DArray[i].y - vector3DArray[i + n2].y;
            double d3 = vector3DArray[i].z - vector3DArray[i + n2].z;
            dArray[i] = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        }
        return dArray;
    }

    public static double planarAngle(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3) {
        double d = vector3D2.x - vector3D3.x;
        double d2 = vector3D2.y - vector3D3.y;
        double d3 = vector3D2.z - vector3D3.z;
        double d4 = vector3D2.x - vector3D.x;
        double d5 = vector3D2.y - vector3D.y;
        double d6 = vector3D2.z - vector3D.z;
        double d7 = d * d4 + d2 * d5 + d3 * d6;
        d7 /= Math.sqrt((d * d + d2 * d2 + d3 * d3) * (d4 * d4 + d5 * d5 + d6 * d6));
        d7 = Math.acos(d7);
        return d7;
    }

    public static double torsionalAngle(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, Vector3D vector3D4) {
        Vector3D vector3D5 = new Vector3D();
        Vector3D vector3D6 = new Vector3D();
        Vector3D vector3D7 = new Vector3D();
        vector3D5.set(vector3D2);
        vector3D5.sub(vector3D);
        vector3D7.set(vector3D3);
        vector3D7.sub(vector3D2);
        Vector3D vector3D8 = Vector3D.vectorProduct(vector3D5, vector3D7);
        double d = vector3D8.length();
        vector3D8.div(d);
        vector3D6.set(vector3D4);
        vector3D6.sub(vector3D3);
        Vector3D vector3D9 = Vector3D.vectorProduct(vector3D7, vector3D6);
        d = vector3D9.length();
        vector3D9.div(d);
        double d2 = Math.acos(vector3D8.x * vector3D9.x + vector3D8.y * vector3D9.y + vector3D8.z * vector3D9.z);
        if (Distances.det3(vector3D2.x, vector3D2.y, vector3D2.z, vector3D3.x, vector3D3.y, vector3D3.z, vector3D4.x, vector3D4.y, vector3D4.z) < 0.0) {
            d2 *= -1.0;
        }
        return d2;
    }

    public static double[] c13(Vector3D[] vector3DArray) {
        if (vector3DArray.length <= 2) {
            return null;
        }
        double[] dArray = new double[vector3DArray.length - 2];
        for (int i = 0; i < vector3DArray.length - 2; ++i) {
            double d = vector3DArray[i + 1].x - vector3DArray[i + 2].x;
            double d2 = vector3DArray[i + 1].y - vector3DArray[i + 2].y;
            double d3 = vector3DArray[i + 1].z - vector3DArray[i + 2].z;
            double d4 = vector3DArray[i + 1].x - vector3DArray[i].x;
            double d5 = vector3DArray[i + 1].y - vector3DArray[i].y;
            double d6 = vector3DArray[i + 1].z - vector3DArray[i].z;
            dArray[i] = d * d4 + d2 * d5 + d3 * d6;
            int n = i;
            dArray[n] = dArray[n] / Math.sqrt((d * d + d2 * d2 + d3 * d3) * (d4 * d4 + d5 * d5 + d6 * d6));
            dArray[i] = Math.acos(dArray[i]);
        }
        return dArray;
    }

    public static double[] t14(Vector3D[] vector3DArray) {
        Vector3D vector3D = new Vector3D();
        Vector3D vector3D2 = new Vector3D();
        Vector3D vector3D3 = new Vector3D();
        if (vector3DArray.length <= 3) {
            return null;
        }
        double[] dArray = new double[vector3DArray.length - 2];
        for (int i = 0; i < vector3DArray.length - 3; ++i) {
            vector3D.set(vector3DArray[i + 1]);
            vector3D.sub(vector3DArray[i]);
            vector3D3.set(vector3DArray[i + 2]);
            vector3D3.sub(vector3DArray[i + 1]);
            Vector3D vector3D4 = Vector3D.vectorProduct(vector3D, vector3D3);
            double d = vector3D4.length();
            vector3D4.div(d);
            vector3D2.set(vector3DArray[i + 3]);
            vector3D2.sub(vector3DArray[i + 2]);
            Vector3D vector3D5 = Vector3D.vectorProduct(vector3D3, vector3D2);
            d = vector3D5.length();
            vector3D5.div(d);
            double d2 = Math.acos(vector3D4.x * vector3D5.x + vector3D4.y * vector3D5.y + vector3D4.z * vector3D5.z);
            if (Distances.det3(vector3D.x, vector3D.y, vector3D.z, vector3D3.x, vector3D3.y, vector3D3.z, vector3D2.x, vector3D2.y, vector3D2.z) < 0.0) {
                d2 *= -1.0;
            }
            dArray[i] = d2;
        }
        return dArray;
    }

    public static void main(String[] stringArray) {
        int n = 100;
        int n2 = 100;
        Atom atom = new Atom();
        TraFrame traFrame = new TraFrame(n);
        atom = new Atom(0, 0.0, 0.0, 0.0);
        for (int i = 1; i < n; ++i) {
            atom = new Atom();
            atom.atom_id = i;
            atom.x = RandGenerator.randNormal();
            atom.y = RandGenerator.randNormal();
            atom.z = RandGenerator.randNormal();
            atom.div(atom.length());
            atom.mul(3.78);
            atom.add(traFrame.atoms[i - 1]);
            traFrame.atoms[i] = atom;
        }
        double[] dArray = Distances.r1K(traFrame.atoms, 4);
        double[] dArray2 = Distances.r1K(traFrame.atoms, 5);
        for (int i = 0; i < dArray2.length; ++i) {
            System.out.println(Format.format(i, 3) + " " + Format.format(dArray[i], 3, 2) + " " + Format.format(dArray2[i], 3, 2));
        }
        System.out.println(Format.format(dArray2.length, 3) + " " + Format.format(dArray[dArray2.length], 3, 2));
    }

    private static double det3(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        return d * d5 * d9 + d2 * d6 * d7 + d3 * d4 * d8 - d7 * d5 * d3 - d8 * d6 * d - d9 * d4 * d2;
    }
}

