/*
 * Decompiled with CFR 0.152.
 */
package jbcl.alignment;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import jbcl.util.AaCodes;
import jbcl.util.Format;

public class SimilarityMatrix {
    public static final byte[][] BLOSUM62 = new byte[][]{{6, 0, 0, -3, -3, -2, -4, -2, -3, -1, 0, -4, -2, -2, -2, -2, -2, -3, -3, -2, -1}, {0, 4, 1, 0, 0, 0, -1, -1, -1, -2, -2, -1, -1, -1, -1, -1, -2, -2, -2, -3, 0}, {0, 1, 4, -1, -2, 1, -2, -1, -1, 0, 1, -2, 0, 0, 0, -1, -1, -2, -2, -3, 0}, {-3, 0, -1, 9, -1, -1, -1, -3, -1, -3, -3, -1, -3, -4, -3, -3, -3, -2, -2, -2, -2}, {-3, 0, -2, -1, 4, 0, 3, -2, 1, -3, -3, 1, -2, -2, -2, -3, -3, -1, -1, -3, -1}, {-2, 0, 1, -1, 0, 5, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -2, -2, -2, -2, 0}, {-4, -1, -2, -1, 3, -1, 4, -3, 1, -3, -3, 2, -3, -3, -3, -3, -3, 0, -1, -3, -1}, {-2, -1, -1, -3, -2, -1, -3, 7, -2, -1, -2, -3, -1, -1, -1, -2, -2, -4, -3, -4, -2}, {-3, -1, -1, -1, 1, -1, 1, -2, 5, -3, -2, 2, -1, -2, 0, -1, -2, 0, -1, -1, -1}, {-1, -2, 0, -3, -3, -1, -3, -1, -3, 6, 1, -4, -1, 2, 0, -2, -1, -3, -3, -4, -1}, {0, -2, 1, -3, -3, 0, -3, -2, -2, 1, 6, -3, 0, 0, 0, 0, 1, -3, -2, -4, -1}, {-4, -1, -2, -1, 1, -1, 2, -3, 2, -4, -3, 4, -2, -3, -2, -2, -3, 0, -1, -2, -1}, {-2, -1, 0, -3, -2, -1, -3, -1, -1, -1, 0, -2, 5, 1, 1, 2, -1, -3, -2, -3, -1}, {-2, -1, 0, -4, -2, -1, -3, -1, -2, 2, 0, -3, 1, 5, 2, 0, 0, -3, -2, -3, -1}, {-2, -1, 0, -3, -2, -1, -3, -1, 0, 0, 0, -2, 1, 2, 5, 1, 0, -3, -1, -2, -1}, {-2, -1, -1, -3, -3, -1, -3, -2, -1, -2, 0, -2, 2, 0, 1, 5, 0, -3, -2, -3, -1}, {-2, -2, -1, -3, -3, -2, -3, -2, -2, -1, 1, -3, -1, 0, 0, 0, 8, -1, 2, -2, -1}, {-3, -2, -2, -2, -1, -2, 0, -4, 0, -3, -3, 0, -3, -3, -3, -3, -1, 6, 3, 1, -1}, {-3, -2, -2, -2, -1, -2, -1, -3, -1, -3, -2, -1, -2, -2, -1, -2, 2, 3, 7, 2, -1}, {-2, -3, -3, -2, -3, -2, -3, -4, -1, -4, -4, -2, -3, -3, -2, -3, -2, 1, 2, 11, -2}, {-1, 0, 0, -2, -1, 0, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1}};
    public static final char COMMENT_PREFIX = '#';
    private static final int SIZE = 63;

    public static byte[][] loadMatrix(String string) {
        int n;
        String[] stringArray;
        String[] stringArray2 = new String[63];
        int n2 = 0;
        byte[][] byArray = new byte[21][21];
        try {
            String string2;
            stringArray = new BufferedReader(new FileReader(new File(string)));
            while ((string2 = stringArray.readLine()) != null) {
                if (string2.charAt(0) == '#') continue;
                stringArray2[n2] = string2.trim();
                ++n2;
            }
            stringArray.close();
        }
        catch (IOException iOException) {
            System.out.println("MatrixLoader::loadMatrix: Can't find file: " + string);
            System.exit(0);
        }
        stringArray = stringArray2[0].split("\\s+");
        byte[] byArray2 = new byte[stringArray.length];
        for (n = 0; n < byArray2.length; n = (int)((byte)(n + 1))) {
            byArray2[n] = AaCodes.aaIndex(stringArray[n].charAt(0));
        }
        for (int n3 = 1; n3 < n2; n3 = (int)((byte)(n3 + 1))) {
            String[] stringArray3 = stringArray2[n3].split("\\s+");
            n = AaCodes.aaIndex(stringArray3[0].charAt(0));
            if (n > 20) continue;
            for (int n4 = 1; n4 < stringArray3.length; n4 = (int)((byte)(n4 + 1))) {
                byte by = byArray2[n4 - 1];
                if (by > 20) continue;
                byArray[n][by] = Byte.parseByte(stringArray3[n4]);
            }
        }
        return byArray;
    }

    public static void showSimilarityMatrix(byte[][] byArray) {
        byte by;
        String string = "   ";
        for (by = 0; by < 21; by = (byte)(by + 1)) {
            string = string + " " + AaCodes.aaName(by) + " ";
        }
        System.out.println(string);
        for (by = 0; by < 21; by = (byte)(by + 1)) {
            string = AaCodes.aaName(by) + " ";
            for (int n = 0; n < 21; n = (int)((byte)(n + 1))) {
                string = string + Format.format(byArray[by][n], 3);
            }
            System.out.println(string);
        }
    }

    public static void showSimilarityMatrix(byte[][] byArray, String string) {
        System.out.println("/// " + string + " substitution matrix");
        System.out.println("  public static final byte[][] " + string + " = {");
        for (int n = 0; n < 21; n = (int)((byte)(n + 1))) {
            String string2 = "    {";
            for (int n2 = 0; n2 < 20; n2 = (int)((byte)(n2 + 1))) {
                string2 = string2 + Format.format(byArray[n][n2], 3) + ",";
            }
            string2 = string2 + Format.format(byArray[n][20], 3) + "},";
            System.out.println(string2);
        }
        System.out.println("    };");
    }

    public static void main(String[] stringArray) {
        byte[][] byArray;
        if (stringArray.length < 1) {
            System.err.println("Usage: SimilarityMatrix matrix_file");
            System.exit(0);
        }
        if (stringArray.length == 1) {
            byArray = SimilarityMatrix.loadMatrix(stringArray[0]);
            SimilarityMatrix.showSimilarityMatrix(byArray);
        }
        if (stringArray.length == 2) {
            byArray = SimilarityMatrix.loadMatrix(stringArray[0]);
            SimilarityMatrix.showSimilarityMatrix(byArray, stringArray[1]);
        }
    }
}

