/*
 * Decompiled with CFR 0.152.
 */
package jbcl.alignment;

import jbcl.alignment.SequenceSimilarity;
import jbcl.alignment.SimilarityMatrix;
import jbcl.util.Format;

public class Align {
    private static final byte STOP_FLAG = 0;
    private static final byte TOP_FLAG = 1;
    private static final byte DIAG_FLAG = 2;
    private static final byte LEFT_FLAG = 3;
    private static int j_size;
    private static int i_size;
    private int[][] ma;
    private int[][] mb;
    private int[][] mc;
    private byte[][] mf;
    private int[][] mm;
    private int[][] s;

    public Align(int[][] nArray) {
        i_size = nArray.length;
        j_size = nArray[0].length;
        this.mm = new int[i_size + 1][j_size + 1];
        this.ma = new int[i_size + 1][j_size + 1];
        this.mb = new int[i_size + 1][j_size + 1];
        this.mc = new int[i_size + 1][j_size + 1];
        this.mf = new byte[i_size + 1][j_size + 1];
        this.s = nArray;
    }

    public void initGlobal(byte by, byte by2) {
    }

    public void initLocal() {
        int n;
        this.ma[0][0] = 0;
        this.mb[0][0] = 0;
        this.mc[0][0] = 0;
        this.mf[0][0] = 0;
        for (n = 1; n <= j_size; ++n) {
            this.ma[0][n] = -32000;
            this.mb[0][n] = -32000;
            this.mc[0][n] = 0;
            this.mf[0][n] = 0;
        }
        for (n = 1; n <= i_size; ++n) {
            this.ma[n][0] = -32000;
            this.mb[n][0] = 0;
            this.mc[n][0] = -32000;
            this.mf[n][0] = 0;
        }
    }

    public void fillLocal(byte by, byte by2) {
        for (int i = 1; i <= i_size; ++i) {
            int[] nArray = this.s[i - 1];
            int[] nArray2 = this.ma[i];
            int[] nArray3 = this.mb[i];
            int[] nArray4 = this.mc[i];
            int[] nArray5 = this.mm[i];
            byte[] byArray = this.mf[i];
            int[] nArray6 = this.ma[i - 1];
            int[] nArray7 = this.mb[i - 1];
            int[] nArray8 = this.mc[i - 1];
            for (int j = 1; j <= j_size; ++j) {
                int n = nArray[j - 1];
                nArray2[j] = Math.max(nArray6[j - 1] + n, Math.max(nArray7[j - 1] + n, Math.max(0, nArray8[j - 1] + n)));
                nArray3[j] = Math.max(nArray6[j] + by, Math.max(nArray7[j] + by2, nArray8[j] + by));
                nArray4[j] = Math.max(nArray2[j - 1] + by, Math.max(nArray3[j - 1] + by, nArray4[j - 1] + by2));
                byArray[j] = 2;
                nArray5[j] = nArray2[j];
                if (nArray5[j] <= nArray3[j]) {
                    if (nArray5[j] == nArray3[j]) {
                        int n2 = j;
                        byArray[n2] = (byte)(byArray[n2] + 1);
                    } else {
                        byArray[j] = 1;
                        nArray5[j] = nArray3[j];
                    }
                }
                if (nArray5[j] <= nArray4[j]) {
                    if (nArray5[j] == nArray4[j]) {
                        int n3 = j;
                        byArray[n3] = (byte)(byArray[n3] + 3);
                    } else {
                        byArray[j] = 3;
                        nArray5[j] = nArray4[j];
                    }
                }
                if (nArray5[j] > 0) continue;
                byArray[j] = 0;
                nArray5[j] = 0;
            }
        }
    }

    public static void main(String[] stringArray) {
        String string;
        String string2;
        if (stringArray.length == 0) {
            string2 = "DDVFAASGFA";
            string = "WYAASFAAIL";
        } else {
            string2 = stringArray[0];
            string = stringArray[1];
        }
        int[][] nArray = SequenceSimilarity.compare(string2, string, SimilarityMatrix.BLOSUM62);
        Align align = new Align(nArray);
        align.initLocal();
        align.fillLocal((byte)-10, (byte)-1);
        System.out.println("Alignment matrix:");
        for (int i = 0; i < align.mm.length; ++i) {
            System.out.println(Format.format(align.mm[i], 3, " "));
        }
    }
}

