import java.util.*;
import java.io.*;

/**
*parse components.cif file and make hashes for ligand type categories according to CAMEO LB http://www.cameo3d.org/cameong_help/lb/
*Category	Description		Rule / Enclosed PDB Type	 						Examples
*I	 	ions	 		type = HETAI, HETIC (non polymeric)						ZN, SO4, ACT, NH4, IOD (All metal and inorganic ions)
*O	 	organic	 		type = HETAIN, ATOMS, ATOMN, ATOMP, HETAC, HETAD (non polymeric with n <= 2)	ATP, FAD, SAM, GLA, F3S
*N	 	Poly-Nucleotides	type = ATOMN (polymeric with n > 2)	 					A, DA, G, U, T
*P	 	Peptides	 	type = ATOMP (polymeric with 2 < n <= 10)	 				ALA, ARG, KCX, LLP, PTR
*/
public class parseChemicalComponentsDictionaryCIF
{	
	Hashtable ligandCategoryHash = new Hashtable();
	Hashtable ligandEnclosedPDBtypeHash = new Hashtable();
	
	public parseChemicalComponentsDictionaryCIF( String components_cif_file )
	{
		try
		{
			BufferedReader in1 = new BufferedReader(new FileReader(components_cif_file));
			String ligline = in1.readLine();
			while( ligline != null )
			{
				if( ligline.startsWith( "_chem_comp.pdbx_type" ) )
				{
					String type = ( ligline.substring( ligline.indexOf( " " ) ) ).trim();
					
					while( !ligline.startsWith( "_chem_comp.three_letter_code" ) )
					{
						ligline = in1.readLine();	
					}
					String TLC = ( ligline.substring( ligline.indexOf( " " ) ) ).trim();
					
					String category = "?";
					if( type.equals( "HETAI" ) || type.equals( "HETIC" ) )
					{
						category = "I";
					}
					if( type.equals( "HETAIN" ) || type.equals( "ATOMS" ) || type.equals( "HETAC" ) || type.equals( "HETAD" ))
					{
						category = "O";
					}
					if( type.equals( "ATOMN" ) )
					{
						category = "N";
					}
					if( type.equals( "ATOMP" ) )
					{
						category = "P";
					}
					ligandCategoryHash.put( TLC, category );
					ligandEnclosedPDBtypeHash.put( TLC, type );
					//System.out.println( TLC + " " + type + " " + category );
				}
				ligline = in1.readLine();
			}
			in1.close();
		}
	
		catch( Exception e )
		{
			System.err.println( "Error running parseChemicalComponentsDictionaryCIF: " + e );
		}
	}
	
	public Hashtable getligandCategoryHash()
	{
		return ligandCategoryHash;
	}
	
	public Hashtable getligandEnclosedPDBtypeHash()
	{
		return ligandEnclosedPDBtypeHash;
	}
	
	public static void main( String args[])
	{
		try
		{
			parseChemicalComponentsDictionaryCIF pccd = new parseChemicalComponentsDictionaryCIF( args[0] );
			System.out.println( pccd.getligandCategoryHash().size() );
		}
		catch( Exception e )
		{
			System.err.println( "Error running parseChemicalComponentsDictionaryCIF: " + e );
		}
	}
}