import java.io.*;
import java.util.*;
import java.lang.*;

/**
*A simple wrapper for TM-align by Yang Zhang and Jeffrey Skolnick, Proteins 2004 57: 702-710
*/
public class runTMalign2
{
	Runtime r = Runtime.getRuntime();
	Process p = null;

	float TMscore = 0; 
	public runTMalign2( String pdbfile1, String pdbfile2, String direct, String supfilename )
	{
		try
		{
			//String bin_path = "/home/daniel/TMalign";
			String bin_path = "$TMALIGN_HOME/TMalign";

			
			String[] runtmalign = {"/bin/bash", "-c", "ulimit -t 3600; cd "+direct+" ;"+bin_path+" " + pdbfile1 + " " + pdbfile2 + " -o " +  supfilename };
			p = r.exec( runtmalign );
			
 			BufferedReader in = new BufferedReader( new InputStreamReader( p.getInputStream() ) );
			String line = in.readLine();
			do
			{
 				if( line.startsWith( "Aligned length=" ) )
 				{
					String TMscorestr = line.substring( line.indexOf("TM-score=")+9, line.lastIndexOf(",") );
					TMscore = (new Float(TMscorestr)).floatValue();				
				}
				line = in.readLine();
			}
			while( line != null );
			p.waitFor();
			in.close();
			p.destroy();
		}
		catch( Exception e )
		{
			System.out.println( "Error executing TMalign!" + e );
		}
	}

	public float getTMscore()
	{
		return TMscore;
	}
		
	public static void main( String args[])
	{
		runTMalign2 rtm2 = new runTMalign2(args[0], args[1], args[2], args[3]);
		System.out.println( rtm2.getTMscore() );
	}
}	
