import java.io.*;
import java.util.*;
import java.lang.*;

/**
*A simple wrapper for TM-align by Yang Zhang and Jeffrey Skolnick, Proteins 2004 57: 702-710
*/
public class runTMalign
{
	Runtime r = Runtime.getRuntime();
	Process p = null;

	float TMscore = 0; 
	public runTMalign( String pdbfile1, String pdbfile2, String direct)
	{
		try
		{
			//String bin_path = "/home/daniel/TMalign";
			String bin_path = "$TMALIGN_HOME/TMalign";
			
			//System.out.println( "cd "+direct+" ;"+bin_path+" " + pdbfile1 + " " + pdbfile2 );
			String[] runtmalign = {"/bin/bash", "-c", "ulimit -t 3600; cd "+direct+" ;"+bin_path+" " + pdbfile1 + " " + pdbfile2 };
			p = r.exec( runtmalign );
			
 			BufferedReader in = new BufferedReader( new InputStreamReader( p.getInputStream() ) );
			String line = in.readLine();
			do
			{
 				if( line.startsWith( "Aligned length=" ) )
 				{
					String TMscorestr = line.substring( line.indexOf("TM-score=")+9, line.lastIndexOf(",") );
					TMscore = (new Float(TMscorestr)).floatValue();				
				}
				line = in.readLine();
			}
			while( line != null );
			p.waitFor();
			in.close();
			p.destroy();
		}
		catch( Exception e )
		{
			System.out.println( "Error executing TMalign!" + e );
		}
	}

	public float getTMscore()
	{
		return TMscore;
	}
		
	public static void main( String args[])
	{
		runTMalign rtm = new runTMalign(args[0], args[1], args[2]);
		System.out.println( rtm.getTMscore() );
	}
}	
