import java.io.*;
import java.util.*;
import java.lang.*;
import java.lang.Math.*;
import java.text.*;
import java.lang.String.*;

/**
*runFunFOLDQA - 
*/

public class runFunFOLDQA
{
	public static void main( String args[])
	{
		try
		{
			// To calculate the BDTalign score
			modelTemplateBDTScore mtbdts = new modelTemplateBDTScore( args[0], args[1], args[2], args[3], args[4] );
			double meanBDTalign = (Double)mtbdts.getmeanBDTalign();
			//System.out.println("running modelTemplateBDTScore in FunFOLDQA .......");
			
			// To calculate the Identity and Rescaled BLOSUM62 score
			equivalentResidueTypeAnalysis erta = new equivalentResidueTypeAnalysis( args[0], args[1], args[2], args[3], args[4] );
			float meanequiresiscore = (Float)erta.getmeanequiresiscore();
			float normalizedmeanequiblossscore = (Float)erta.getnormalizedmeanequiblossscore();
			//System.out.println("running equivalentResidueTypeAnalysis in FunFOLDQA .......");


			// Equivalent Residue Ligand Distance score
			equivalentLigResiDist elrd = new equivalentLigResiDist( args[0], args[1], args[2], args[3], args[4] );
			//System.out.println("running equivalentLigResiDist in FunFOLDQA .......");

			String lig2 = args[4].trim()+"_lig2.pdb";

			CAMEOScoringCode csc = new CAMEOScoringCode( args[0], args[2], lig2, args[5] );
			StringBuffer outputresults  = (StringBuffer)csc.getoutputresults();
			System.out.println(outputresults.toString());
			

			CAMEOligCategoryVariation cameolcv = new CAMEOligCategoryVariation( args[2] );
			StringBuffer  OutputBuff = (StringBuffer)cameolcv.getOutputBuff();
			System.out.println("Calculation global binding site biochemical propensity scores .....");
			System.out.println(OutputBuff.toString());

	      

			float meanqscore = (Float)elrd.getmeanqscore();

			
			DataOutputStream out1 = new DataOutputStream( new FileOutputStream( args[0] +  args[4]  + ".pat" ) );

			//Tidy up and mv the "*_bs.out" file to output directory
			File file = new File(args[4]+"_bs.out");
			File dir = new File(args[0]);
			file.renameTo(new File(dir, file.getName()));

			//System.out.println("Starting to run BPN");
			
			
			// if we are not using model quality
			//if ( args[5].toUpperCase().trim().equals("NULL"))
			if( args.length == 5 )
			{
				//Write out the pattern file
				out1.writeBytes( "1" + "\n"+"4" + "\n"+"1"+"\n"+ args[4] + " " + args[3] + " " + meanBDTalign  + " " + meanequiresiscore  + " " + normalizedmeanequiblossscore + " " + meanqscore );
				out1.close();
				
				//System.out.println("Not using ModFOLD score");
				
				//Running BPN to read in the Neural Network weights file to calculate the predictive MCC and BDT scores
				BackpropagationNet2 bpn1 = new BackpropagationNet2();
				bpn1.readConversionFile("ascii2bin3.cnv");
				bpn1.addNeuronLayer(4);
				bpn1.addNeuronLayer(4);
				bpn1.addNeuronLayer(1);
				bpn1.connectLayers();

				// Loading weights file
				bpn1.load( "BDTweightsnoModelQuality.pat.weights" );
				bpn1.readPatternFile( args[0] + args[4]  + ".pat" );

				//Creating outputstream to write out final results file 
				DataOutputStream neuraloutput = new DataOutputStream( new FileOutputStream( args[0] +  args[4]  + "BDT.pat" + ".out2" ) );
				BufferedReader patin = new BufferedReader( new FileReader( args[0] +  args[4]  + ".pat" ) );;

				// Reading in the pattern file
				String patline = patin.readLine();
				patline = patin.readLine();
				patline = patin.readLine();

				// getting the predictive score 
				for(int j = 0; j < bpn1.getNumberOfPatterns(); j++)
				{
					float s1 = (new Float(bpn1.recall(bpn1.getInputPattern(j) ))).floatValue();
					float mean = s1;
					
					String out = bpn1.getTargetPattern(j);
					patline = patin.readLine();
					StringTokenizer linetokens = new StringTokenizer(patline);
					String filename1 = linetokens.nextToken();
					String filename2 = linetokens.nextToken();

					neuraloutput.writeBytes( patline + " " + mean + "\n" );
					//System.out.println( "Writing out final results file BDT: " + args[0] +  args[4]  + "BDT.pat" + ".out2" );
				}	
				neuraloutput.close();	
				patin.close();
				
				// Loading weights file
				bpn1.load( "MCCweightsnoModelQuality.pat.weights" );
				//System.out.println("reading MCC pattern file");
				bpn1.readPatternFile( args[0] +  args[4]  + ".pat" );
				
				//Creating outputstream to write out final results file 
				DataOutputStream neuraloutput1 = new DataOutputStream( new FileOutputStream( args[0] +  args[4]  + "MCC.pat" + ".out2" ) );
				BufferedReader patin1 = new BufferedReader( new FileReader( args[0] +  args[4]  + ".pat" ) );

				// Reading in the pattern file
				String patline1 = patin1.readLine();
				patline1 = patin1.readLine();
				patline1 = patin1.readLine();

				// getting the predictive score 
				for(int j = 0; j < bpn1.getNumberOfPatterns(); j++)
				{
					float s1 = (new Float(bpn1.recall(bpn1.getInputPattern(j) ))).floatValue();
					float mean = s1;
					
					String out = bpn1.getTargetPattern(j);
					patline1 = patin1.readLine();
					StringTokenizer linetokens = new StringTokenizer(patline1);
					String filename1 = linetokens.nextToken();
					String filename2 = linetokens.nextToken();

					neuraloutput1.writeBytes( patline + " " + mean + "\n" );
					//System.out.println( "Writing out final results file MCC: " + args[0] +  args[4]  + "MCC.pat" + ".out2" );
					
				}
				neuraloutput1.close();	
				patin1.close();	

			}
				
			// if we are using model quality
			//if ( !args[5].toUpperCase().trim().equals("NULL")) 
			if( args.length == 6 )
			{
				//Write out the pattern file
				
				//System.out.println("writing out pappern file");
				out1.writeBytes( "1" + "\n"+"5" + "\n"+"1"+"\n"+ args[4] + " " + args[3] + " " + meanBDTalign  + " " + meanequiresiscore  + " " + normalizedmeanequiblossscore + " " + meanqscore  + " " + args[5]);
				out1.close();

				//Running BPN to read in the Neural Network weights file to calculate the predictive MCC and BDT scores
				BackpropagationNet2 bpn1 = new BackpropagationNet2();
				bpn1.readConversionFile("ascii2bin3.cnv");
				bpn1.addNeuronLayer(5);
				bpn1.addNeuronLayer(5);
				bpn1.addNeuronLayer(1);
				bpn1.connectLayers();
				//System.out.println("Using ModFOLD score" );

				//System.out.println("Loading weights");
				// Loading weights file
				bpn1.load( "BDTweightsModelQuality.pat.weights" );
				//System.out.println("reading BDT pattern file");
				bpn1.readPatternFile( args[0] +  args[4]  + ".pat" );

				//Creating outputstream to write out final results file 
				DataOutputStream neuraloutput = new DataOutputStream( new FileOutputStream( args[0] +  args[4]  + "BDT.pat" + ".out2" ) );
				
				BufferedReader patin = new BufferedReader( new FileReader( args[0] +  args[4]  + ".pat" ) );

				// Reading in the pattern file
				String patline = patin.readLine();
				patline = patin.readLine();
				patline = patin.readLine();

				// getting the predictive score 
				for(int j = 0; j < bpn1.getNumberOfPatterns(); j++)
				{
					float s1 = (new Float(bpn1.recall(bpn1.getInputPattern(j) ))).floatValue();
					float mean = s1;
					
					String out = bpn1.getTargetPattern(j);
					patline = patin.readLine();
					StringTokenizer linetokens = new StringTokenizer(patline);
					String filename1 = linetokens.nextToken();
					String filename2 = linetokens.nextToken();

					neuraloutput.writeBytes( patline + " " + mean + "\n" );
					//System.out.println("writing out output stream ");
					//System.out.println( "Writing out final results file BDT: "+ args[0] +  args[4]  + "BDT.pat" + ".out2");
					
				}
				neuraloutput.close();	
				patin.close();
				
				// Loading weights file
				bpn1.load( "MCCweightsModelQuality.pat.weights" );
				//System.out.println("reading MCC pattern file");
				bpn1.readPatternFile( args[0] +  args[4]  + ".pat" );
				//System.out.println( "Directory - "+ args[0] + args[4]  + ".pat" );

				//Creating outputstream to write out final results file 
				DataOutputStream neuraloutput1 = new DataOutputStream( new FileOutputStream( args[0] +  args[4]  + "MCC.pat" + ".out2" ) );
				BufferedReader patin1 = new BufferedReader( new FileReader( args[0] +  args[4]  + ".pat" ) );

				// Reading in the pattern file
				String patline1 = patin1.readLine();
				patline1 = patin1.readLine();
				patline1 = patin1.readLine();

				// getting the predictive score 
				for(int j = 0; j < bpn1.getNumberOfPatterns(); j++)
				{
					float s1 = (new Float(bpn1.recall(bpn1.getInputPattern(j) ))).floatValue();
					float mean = s1;
					
					String out = bpn1.getTargetPattern(j);
					patline1 = patin1.readLine();
					StringTokenizer linetokens = new StringTokenizer(patline1);
					String filename1 = linetokens.nextToken();
					String filename2 = linetokens.nextToken();

					neuraloutput1.writeBytes( patline + " " + mean + "\n" );
					//System.out.println( "Writing out final results file MCC: " +  args[0] +  args[4]  + "MCC.pat" + ".out2");
					
				}
				neuraloutput1.close();	
				patin1.close();	
			}

			// Reading in the results file BDT to get all of the predictive scores 
			FileReader file1 = new FileReader( args[0] +  args[4]  + "BDT.pat" + ".out2" );
			BufferedReader in = new BufferedReader(file1);
			String line1 = in.readLine();
	
			do
			{  
				StringTokenizer linetokens = new StringTokenizer(line1, " ,\t");
				String filename1 = linetokens.nextToken();
				String filename2 = linetokens.nextToken();
				String token3 = linetokens.nextToken();
				System.out.println("BDTalign = " + token3);
				String token4 = linetokens.nextToken();
				System.out.println("Identity = " + token4);
				String token5 = linetokens.nextToken();
				System.out.println("Rescaled BLOSUM62 = " + token5);
				String token6 = linetokens.nextToken();
				System.out.println("Equivalent Residue Ligand Distance = " + token6);
				
				// if model quality or not
				//if ( !args[5].toUpperCase().trim().equals("NULL"))
				if( args.length == 6 )
				{
					String token7 = linetokens.nextToken();
					System.out.println("Model Quality = " + token7);
				}
				
				String FunFOLDQAscore = linetokens.nextToken();
				System.out.println( "Predicted BDT score = " + FunFOLDQAscore);
				line1 = in.readLine();
			}
			while( line1 != null );

			// Reading in the results file BDT to get all of the predictive scores 
			FileReader file2 = new FileReader( args[0] +  args[4]  + "MCC.pat" + ".out2" );
			BufferedReader in1 = new BufferedReader(file2);
			String line2 = in1.readLine();
			
			do
			{  
				StringTokenizer linetokens = new StringTokenizer(line2, " ,\t");
				String filename1 = linetokens.nextToken();
				String filename2 = linetokens.nextToken();
				String token3 = linetokens.nextToken();
				String token4 = linetokens.nextToken();
				String token5 = linetokens.nextToken();
				String token6 = linetokens.nextToken();
				
				// if model quality or not
				//if ( !args[5].toUpperCase().trim().equals("NULL"))
				if( args.length == 6 )
				{
					String token7 = linetokens.nextToken();
				}
				
				String FunFOLDQAscore = linetokens.nextToken();
				System.out.println( "Predicted MCC score = " + FunFOLDQAscore);
				line2 = in.readLine();
			}
			while( line2 != null );
		}
	
		catch( Exception e )
		{
			System.out.println( "Error executing runFunFOLDQA!" + e );
		}	
	}
}
			